/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.client.dtos.DataType;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.matchers.Matcher;
import io.split.engine.matchers.Transformers;
import java.util.Map;

public class LessThanOrEqualToMatcher
implements Matcher {
    private final long _compareTo;
    private final long _normalizedCompareTo;
    private final DataType _dataType;

    public LessThanOrEqualToMatcher(long compareTo, DataType dataType) {
        this._compareTo = compareTo;
        this._dataType = dataType;
        this._normalizedCompareTo = this._dataType == DataType.DATETIME ? Transformers.asDateHourMinute(this._compareTo) : this._compareTo;
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, Evaluator evaluator) {
        Long keyAsLong = this._dataType == DataType.DATETIME ? Transformers.asDateHourMinute(matchValue) : Transformers.asLong(matchValue);
        if (keyAsLong == null) {
            return false;
        }
        return keyAsLong <= this._normalizedCompareTo;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("<= ");
        bldr.append(this._compareTo);
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this._compareTo ^ this._compareTo >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LessThanOrEqualToMatcher)) {
            return false;
        }
        LessThanOrEqualToMatcher other = (LessThanOrEqualToMatcher)obj;
        return this._compareTo == other._compareTo;
    }
}

