/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.adapters;

import io.split.storages.SegmentCacheConsumer;
import io.split.storages.pluggable.CustomStorageWrapper;
import io.split.storages.pluggable.domain.PrefixAdapter;
import io.split.storages.pluggable.domain.SafeUserStorageWrapper;
import io.split.storages.pluggable.utils.Helper;
import java.util.Set;
import split.com.google.common.base.Preconditions;

public class UserCustomSegmentAdapterConsumer
implements SegmentCacheConsumer {
    private final SafeUserStorageWrapper _safeUserStorageWrapper;

    public UserCustomSegmentAdapterConsumer(CustomStorageWrapper customStorageWrapper) {
        this._safeUserStorageWrapper = new SafeUserStorageWrapper(Preconditions.checkNotNull(customStorageWrapper));
    }

    @Override
    public long getChangeNumber(String segmentName) {
        String wrapperResponse = this._safeUserStorageWrapper.get(PrefixAdapter.buildSegment(segmentName));
        return Helper.responseToLong(wrapperResponse, -1L);
    }

    @Override
    public boolean isInSegment(String segmentName, String key) {
        return this._safeUserStorageWrapper.itemContains(PrefixAdapter.buildSegment(segmentName), key);
    }

    @Override
    public long getSegmentCount() {
        Set<String> keys = this._safeUserStorageWrapper.getKeysByPrefix(PrefixAdapter.buildSegmentAll());
        return keys == null ? 0L : (long)keys.size();
    }

    @Override
    public long getKeyCount() {
        Set<String> keys = this._safeUserStorageWrapper.getKeysByPrefix(PrefixAdapter.buildSegmentAll());
        if (keys == null) {
            return 0L;
        }
        return keys.stream().mapToLong(key -> this._safeUserStorageWrapper.getItemsCount((String)key)).sum();
    }
}

