/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.domain;

import io.split.storages.pluggable.CustomStorageWrapper;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class SafeUserStorageWrapper
implements CustomStorageWrapper {
    private static final Logger _log = LoggerFactory.getLogger(SafeUserStorageWrapper.class);
    private final CustomStorageWrapper _customStorageWrapper;

    public SafeUserStorageWrapper(CustomStorageWrapper customStorageWrapper) {
        this._customStorageWrapper = Preconditions.checkNotNull(customStorageWrapper);
    }

    @Override
    public String get(String key) {
        try {
            return this._customStorageWrapper.get(key);
        }
        catch (Exception e) {
            _log.error(String.format("error fetching key '%s' from storage. Error: '%s'", key, e.getMessage()));
            return null;
        }
    }

    @Override
    public List<String> getMany(List<String> keys) {
        try {
            return this._customStorageWrapper.getMany(keys);
        }
        catch (Exception e) {
            _log.error(String.format("error fetching keys '%s' from storage. Error: '%s'", keys, e.getMessage()));
            return null;
        }
    }

    @Override
    public void set(String key, String item) {
        try {
            this._customStorageWrapper.set(key, item);
        }
        catch (Exception e) {
            _log.error(String.format("error updating key '%s' from storage. Error: '%s'", key, e.getMessage()));
        }
    }

    @Override
    public void delete(List<String> keys) {
        try {
            this._customStorageWrapper.delete(keys);
        }
        catch (Exception e) {
            _log.error(String.format("error deleting keys '%s' from storage. Error: '%s'", keys, e.getMessage()));
        }
    }

    @Override
    public String getAndSet(String key, String item) {
        try {
            return this._customStorageWrapper.getAndSet(key, item);
        }
        catch (Exception e) {
            _log.error(String.format("error getting and updating key '%s' from storage. Error: '%s'", key, e.getMessage()));
            return null;
        }
    }

    @Override
    public Set<String> getKeysByPrefix(String prefix) {
        try {
            return this._customStorageWrapper.getKeysByPrefix(prefix);
        }
        catch (Exception e) {
            _log.error(String.format("error getting keys '%s' from storage. Error: '%s'", prefix, e.getMessage()));
            return null;
        }
    }

    @Override
    public long increment(String key, long value) {
        try {
            return this._customStorageWrapper.increment(key, value);
        }
        catch (Exception e) {
            _log.error(String.format("error incrementing key '%s' from storage. Error: '%s'", key, e.getMessage()));
            return 0L;
        }
    }

    @Override
    public long decrement(String key, long value) {
        try {
            return this._customStorageWrapper.decrement(key, value);
        }
        catch (Exception e) {
            _log.error(String.format("error decrementing key '%s' from storage. Error: '%s'", key, e.getMessage()));
            return 0L;
        }
    }

    @Override
    public void pushItems(String key, List<String> items) {
        try {
            this._customStorageWrapper.pushItems(key, items);
        }
        catch (Exception e) {
            _log.error(String.format("error pushing items with key '%s' from storage. Error: '%s'", key, e.getMessage()));
        }
    }

    @Override
    public List<String> popItems(String key, long count) {
        try {
            return this._customStorageWrapper.popItems(key, count);
        }
        catch (Exception e) {
            _log.error(String.format("error popping key '%s' from storage. Error: '%s'", key, e.getMessage()));
            return null;
        }
    }

    @Override
    public long getItemsCount(String key) {
        try {
            return this._customStorageWrapper.getItemsCount(key);
        }
        catch (Exception e) {
            _log.error(String.format("error getting items count key '%s' from storage. Error: '%s'", key, e.getMessage()));
            return -1L;
        }
    }

    @Override
    public boolean itemContains(String key, String item) {
        try {
            return this._customStorageWrapper.itemContains(key, item);
        }
        catch (Exception e) {
            _log.error(String.format("error checking if item contains key '%s' from storage. Error: '%s'", key, e.getMessage()));
            return false;
        }
    }

    @Override
    public void addItems(String key, List<String> items) {
        try {
            this._customStorageWrapper.addItems(key, items);
        }
        catch (Exception e) {
            _log.error(String.format("error adding items with key '%s' from storage. Error: '%s'", key, e.getMessage()));
        }
    }

    @Override
    public void removeItems(String key, List<String> items) {
        try {
            this._customStorageWrapper.removeItems(key, items);
        }
        catch (Exception e) {
            _log.error(String.format("error removing items with key '%s' from storage. Error: '%s'", key, e.getMessage()));
        }
    }

    @Override
    public List<String> getItems(List<String> keys) {
        try {
            return this._customStorageWrapper.getItems(keys);
        }
        catch (Exception e) {
            _log.error(String.format("error getting items with keys '%s' from storage. Error: '%s'", keys, e.getMessage()));
            return null;
        }
    }

    @Override
    public boolean connect() {
        try {
            return this._customStorageWrapper.connect();
        }
        catch (Exception e) {
            _log.error(String.format("error trying to connect. Error: '%s'", e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean close() {
        try {
            return this._customStorageWrapper.close();
        }
        catch (Exception e) {
            _log.error(String.format("error trying to connect. Error: '%s'", e.getMessage()));
            return false;
        }
    }
}

