/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.events;

import io.split.client.dtos.Event;
import io.split.client.events.EventsSender;
import io.split.client.events.EventsStorageConsumer;
import io.split.client.events.EventsStorageProducer;
import io.split.client.events.WrappedEvent;
import io.split.client.utils.Utils;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class EventsTask {
    public static final Long MAX_SIZE_BYTES = 0x500000L;
    private final EventsStorageConsumer _eventsStorageConsumer;
    private final EventsStorageProducer _eventsStorageProducer;
    private final EventsSender _eventsSender;
    private final int _maxQueueSize;
    private final long _flushIntervalMillis;
    private final ExecutorService _senderExecutor;
    private final ExecutorService _consumerExecutor;
    private final ScheduledExecutorService _flushScheduler;
    static final Event SENTINEL = new Event();
    private static final Logger _log = LoggerFactory.getLogger(EventsTask.class);
    private final CloseableHttpClient _httpclient;
    private final URI _target;
    private final int _waitBeforeShutdown;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    ThreadFactory eventClientThreadFactory(String name) {
        return r -> new Thread(() -> {
            Thread.currentThread().setPriority(1);
            r.run();
        }, name);
    }

    public static EventsTask create(CloseableHttpClient httpclient, URI eventsRootTarget, int maxQueueSize, long flushIntervalMillis, int waitBeforeShutdown, TelemetryRuntimeProducer telemetryRuntimeProducer, EventsStorageConsumer eventsStorageConsumer, EventsStorageProducer _eventsStorageProducer) throws URISyntaxException {
        return new EventsTask(eventsStorageConsumer, _eventsStorageProducer, httpclient, Utils.appendPath(eventsRootTarget, "api/events/bulk"), maxQueueSize, flushIntervalMillis, waitBeforeShutdown, telemetryRuntimeProducer);
    }

    EventsTask(EventsStorageConsumer eventsStorageConsumer, EventsStorageProducer eventsStorageProducer, CloseableHttpClient httpclient, URI target, int maxQueueSize, long flushIntervalMillis, int waitBeforeShutdown, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        this._httpclient = Preconditions.checkNotNull(httpclient);
        this._target = Preconditions.checkNotNull(target);
        this._eventsStorageConsumer = Preconditions.checkNotNull(eventsStorageConsumer);
        this._eventsStorageProducer = Preconditions.checkNotNull(eventsStorageProducer);
        this._waitBeforeShutdown = waitBeforeShutdown;
        this._maxQueueSize = maxQueueSize;
        this._flushIntervalMillis = flushIntervalMillis;
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._eventsSender = EventsSender.create(this._httpclient, this._target, this._telemetryRuntimeProducer);
        this._senderExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(50), this.eventClientThreadFactory("eventclient-sender"), (r, executor) -> _log.warn("Executor queue full. Dropping events."));
        this._consumerExecutor = Executors.newSingleThreadExecutor(this.eventClientThreadFactory("eventclient-consumer"));
        this._consumerExecutor.submit(this.runConsumer());
        this._flushScheduler = Executors.newScheduledThreadPool(1, this.eventClientThreadFactory("eventclient-flush"));
        this._flushScheduler.scheduleAtFixedRate(() -> this.flush(), this._flushIntervalMillis, this._flushIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void flush() {
        this._eventsStorageProducer.track(SENTINEL, 0);
    }

    public void close() {
        try {
            this._consumerExecutor.shutdownNow();
            this._flushScheduler.shutdownNow();
            this._senderExecutor.awaitTermination(this._waitBeforeShutdown, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            _log.warn("Error when shutting down EventClientImpl", (Throwable)e);
        }
    }

    private Runnable runConsumer() {
        Runnable runnable = () -> {
            ArrayList<Event> events = new ArrayList<Event>();
            long accumulated = 0L;
            while (!Thread.currentThread().isInterrupted()) {
                WrappedEvent data = this._eventsStorageConsumer.pop();
                Event event = data.event();
                Long size = data.size();
                if (event != SENTINEL) {
                    events.add(event);
                    accumulated += size.longValue();
                } else if (events.size() < 1) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug("No messages to publish.");
                    continue;
                }
                if (events.size() < this._maxQueueSize && accumulated < MAX_SIZE_BYTES && event != SENTINEL) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug(String.format("Sending %d events", events.size()));
                }
                ArrayList<Event> finalEvents = events;
                Runnable r = () -> this._eventsSender.sendEvents(finalEvents);
                this._senderExecutor.submit(r);
                events = new ArrayList();
                accumulated = 0L;
            }
        };
        return runnable;
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

