/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse;

import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.PushStatusTracker;
import io.split.engine.sse.dtos.IncomingNotification;
import io.split.engine.sse.dtos.SegmentQueueDto;
import io.split.engine.sse.dtos.StatusNotification;
import io.split.engine.sse.workers.SplitsWorker;
import io.split.engine.sse.workers.Worker;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class NotificationProcessorImp
implements NotificationProcessor {
    private final SplitsWorker _splitsWorker;
    private final Worker<SegmentQueueDto> _segmentWorker;
    private final PushStatusTracker _pushStatusTracker;

    @VisibleForTesting
    NotificationProcessorImp(SplitsWorker splitsWorker, Worker<SegmentQueueDto> segmentWorker, PushStatusTracker pushStatusTracker) {
        this._splitsWorker = Preconditions.checkNotNull(splitsWorker);
        this._segmentWorker = Preconditions.checkNotNull(segmentWorker);
        this._pushStatusTracker = Preconditions.checkNotNull(pushStatusTracker);
    }

    public static NotificationProcessorImp build(SplitsWorker splitsWorker, Worker<SegmentQueueDto> segmentWorker, PushStatusTracker pushStatusTracker) {
        return new NotificationProcessorImp(splitsWorker, segmentWorker, pushStatusTracker);
    }

    @Override
    public void process(IncomingNotification notification) {
        notification.handler(this);
    }

    @Override
    public void processSplitUpdate(long changeNumber) {
        this._splitsWorker.addToQueue(changeNumber);
    }

    @Override
    public void processSplitKill(long changeNumber, String splitName, String defaultTreatment) {
        this._splitsWorker.killSplit(changeNumber, splitName, defaultTreatment);
        this._splitsWorker.addToQueue(changeNumber);
    }

    @Override
    public void processSegmentUpdate(long changeNumber, String segmentName) {
        this._segmentWorker.addToQueue(new SegmentQueueDto(segmentName, changeNumber));
    }

    @Override
    public void processStatus(StatusNotification statusNotification) {
        statusNotification.handlerStatus(this._pushStatusTracker);
    }
}

