/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.events;

import io.split.client.dtos.Event;
import io.split.client.utils.Utils;
import io.split.service.HttpPostImp;
import io.split.telemetry.domain.enums.HttpParamsWrapper;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.gson.internal.$Gson$Preconditions;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class EventsSender {
    private static final String BULK_ENDPOINT_PATH = "api/events/bulk";
    private final URI _bulkEndpoint;
    private final CloseableHttpClient _client;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final HttpPostImp _httpPostImp;

    public static EventsSender create(CloseableHttpClient httpclient, URI eventsTarget, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        return new EventsSender(httpclient, Utils.appendPath(eventsTarget, BULK_ENDPOINT_PATH), telemetryRuntimeProducer);
    }

    EventsSender(CloseableHttpClient httpclient, URI eventsTarget, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = $Gson$Preconditions.checkNotNull(httpclient);
        this._bulkEndpoint = $Gson$Preconditions.checkNotNull(eventsTarget);
        this._telemetryRuntimeProducer = $Gson$Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._httpPostImp = new HttpPostImp(httpclient, telemetryRuntimeProducer);
    }

    public void sendEvents(List<Event> _data) {
        this._httpPostImp.post(this._bulkEndpoint, _data, "Events ", HttpParamsWrapper.EVENTS);
    }

    @VisibleForTesting
    URI getBulkEndpoint() {
        return this._bulkEndpoint;
    }
}

