/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.adapters;

import io.split.client.utils.SDKMetadata;
import io.split.storages.pluggable.domain.PrefixAdapter;
import io.split.storages.pluggable.domain.UserStorageWrapper;
import io.split.telemetry.domain.StreamingEvent;
import io.split.telemetry.domain.enums.EventsDataRecordsEnum;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.ImpressionsDataTypeEnum;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.domain.enums.MethodEnum;
import io.split.telemetry.domain.enums.ResourceEnum;
import io.split.telemetry.storage.TelemetryStorageProducer;
import io.split.telemetry.utils.BucketCalculator;
import pluggable.CustomStorageWrapper;
import split.com.google.common.base.Preconditions;

public class UserCustomTelemetryAdapterProducer
implements TelemetryStorageProducer {
    private final UserStorageWrapper _userStorageWrapper;
    private SDKMetadata _sdkMetadata;

    public UserCustomTelemetryAdapterProducer(CustomStorageWrapper customStorageWrapper, SDKMetadata sdkMetadata) {
        this._userStorageWrapper = new UserStorageWrapper(Preconditions.checkNotNull(customStorageWrapper));
        this._sdkMetadata = sdkMetadata;
    }

    @Override
    public void recordNonReadyUsage() {
    }

    @Override
    public void recordBURTimeout() {
    }

    @Override
    public void recordLatency(MethodEnum method, long latency) {
        String key = String.format("%s/%s/%s/%s/%d", this._sdkMetadata.getSdkVersion(), this._sdkMetadata.getMachineName(), this._sdkMetadata.getMachineIp(), method.getMethod(), BucketCalculator.getBucketForLatency(latency));
        this._userStorageWrapper.hIncrement(PrefixAdapter.buildTelemetryLatenciesPrefix(), key, 1L);
    }

    @Override
    public void recordException(MethodEnum method) {
        String key = String.format("%s/%s/%s/%s", this._sdkMetadata.getSdkVersion(), this._sdkMetadata.getMachineName(), this._sdkMetadata.getMachineIp(), method.getMethod());
        this._userStorageWrapper.hIncrement(PrefixAdapter.buildTelemetryExceptionsPrefix(), key, 1L);
    }

    @Override
    public void addTag(String tag) {
    }

    @Override
    public void recordImpressionStats(ImpressionsDataTypeEnum dataType, long count) {
    }

    @Override
    public void recordEventStats(EventsDataRecordsEnum dataType, long count) {
    }

    @Override
    public void recordSuccessfulSync(LastSynchronizationRecordsEnum resource, long time) {
    }

    @Override
    public void recordSyncError(ResourceEnum resource, int status) {
    }

    @Override
    public void recordSyncLatency(HTTPLatenciesEnum resource, long latency) {
    }

    @Override
    public void recordAuthRejections() {
    }

    @Override
    public void recordTokenRefreshes() {
    }

    @Override
    public void recordStreamingEvents(StreamingEvent streamingEvent) {
    }

    @Override
    public void recordSessionLength(long sessionLength) {
    }
}

