/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.ApiKeyCounter;
import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.LocalhostSegmentChangeFetcher;
import io.split.client.LocalhostSegmentFetcherNoop;
import io.split.client.LocalhostSplitChangeFetcher;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitClientImpl;
import io.split.client.SplitFactory;
import io.split.client.SplitManager;
import io.split.client.SplitManagerImpl;
import io.split.client.dtos.Metadata;
import io.split.client.events.EventsSender;
import io.split.client.events.EventsTask;
import io.split.client.events.InMemoryEventsStorage;
import io.split.client.events.NoopEventsStorageImp;
import io.split.client.impressions.AsynchronousImpressionListener;
import io.split.client.impressions.HttpImpressionsSender;
import io.split.client.impressions.ImpressionCounter;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionObserver;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.impressions.ImpressionsManagerImpl;
import io.split.client.impressions.ImpressionsSender;
import io.split.client.impressions.ImpressionsStorageConsumer;
import io.split.client.impressions.ImpressionsStorageProducer;
import io.split.client.impressions.InMemoryImpressionsStorage;
import io.split.client.impressions.PluggableImpressionSender;
import io.split.client.impressions.UniqueKeysTracker;
import io.split.client.impressions.UniqueKeysTrackerImp;
import io.split.client.impressions.strategy.ProcessImpressionDebug;
import io.split.client.impressions.strategy.ProcessImpressionNone;
import io.split.client.impressions.strategy.ProcessImpressionOptimized;
import io.split.client.impressions.strategy.ProcessImpressionStrategy;
import io.split.client.interceptors.AuthorizationInterceptorFilter;
import io.split.client.interceptors.ClientKeyInterceptorFilter;
import io.split.client.interceptors.GzipDecoderResponseInterceptor;
import io.split.client.interceptors.GzipEncoderRequestInterceptor;
import io.split.client.interceptors.SdkMetadataInterceptorFilter;
import io.split.client.utils.SDKMetadata;
import io.split.engine.SDKReadinessGates;
import io.split.engine.common.ConsumerSyncManager;
import io.split.engine.common.ConsumerSynchronizer;
import io.split.engine.common.LocalhostSyncManager;
import io.split.engine.common.LocalhostSynchronizer;
import io.split.engine.common.SplitAPI;
import io.split.engine.common.SplitTasks;
import io.split.engine.common.SyncManager;
import io.split.engine.common.SyncManagerImp;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.evaluator.EvaluatorImp;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitFetcherImp;
import io.split.engine.experiments.SplitParser;
import io.split.engine.experiments.SplitSynchronizationTask;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.engine.segments.SegmentSynchronizationTaskImp;
import io.split.integrations.IntegrationsConfig;
import io.split.storages.SegmentCacheConsumer;
import io.split.storages.SegmentCacheProducer;
import io.split.storages.SplitCacheConsumer;
import io.split.storages.SplitCacheProducer;
import io.split.storages.enums.OperationMode;
import io.split.storages.memory.InMemoryCacheImp;
import io.split.storages.memory.SegmentCacheInMemoryImpl;
import io.split.storages.pluggable.adapters.UserCustomEventAdapterProducer;
import io.split.storages.pluggable.adapters.UserCustomImpressionAdapterConsumer;
import io.split.storages.pluggable.adapters.UserCustomImpressionAdapterProducer;
import io.split.storages.pluggable.adapters.UserCustomSegmentAdapterConsumer;
import io.split.storages.pluggable.adapters.UserCustomSplitAdapterConsumer;
import io.split.storages.pluggable.adapters.UserCustomTelemetryAdapterProducer;
import io.split.storages.pluggable.domain.UserStorageWrapper;
import io.split.storages.pluggable.synchronizer.TelemetryConsumerSubmitter;
import io.split.telemetry.storage.InMemoryTelemetryStorage;
import io.split.telemetry.storage.NoopTelemetryStorage;
import io.split.telemetry.storage.TelemetryStorageProducer;
import io.split.telemetry.synchronizer.TelemetryInMemorySubmitter;
import io.split.telemetry.synchronizer.TelemetrySyncTask;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluggable.CustomStorageWrapper;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;
import split.org.apache.hc.client5.http.auth.AuthScope;
import split.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import split.org.apache.hc.client5.http.config.RequestConfig;
import split.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import split.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import split.org.apache.hc.client5.http.impl.classic.HttpClients;
import split.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import split.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import split.org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import split.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import split.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import split.org.apache.hc.core5.http.io.SocketConfig;
import split.org.apache.hc.core5.http.ssl.TLS;
import split.org.apache.hc.core5.ssl.SSLContexts;
import split.org.apache.hc.core5.util.TimeValue;
import split.org.apache.hc.core5.util.Timeout;

public class SplitFactoryImpl
implements SplitFactory {
    private static final Logger _log = LoggerFactory.getLogger(SplitFactory.class);
    private static final long SSE_CONNECT_TIMEOUT = 30000L;
    private static final long SSE_SOCKET_TIMEOUT = 70000L;
    private static Random RANDOM = new Random();
    private final SDKReadinessGates _gates;
    private final ImpressionsManager _impressionsManager;
    private final Evaluator _evaluator;
    private final String _apiToken;
    private final SplitClient _client;
    private final SplitManager _manager;
    private final SplitCacheConsumer _splitCache;
    private final SegmentCacheConsumer _segmentCache;
    private boolean isTerminated = false;
    private final ApiKeyCounter _apiKeyCounter;
    private final TelemetryStorageProducer _telemetryStorageProducer;
    private final TelemetrySynchronizer _telemetrySynchronizer;
    private long _startTime;
    private final SDKMetadata _sdkMetadata;
    private OperationMode _operationMode;
    private final TelemetrySyncTask _telemetrySyncTask;
    private final SegmentSynchronizationTaskImp _segmentSynchronizationTaskImp;
    private final SplitFetcher _splitFetcher;
    private final SplitSynchronizationTask _splitSynchronizationTask;
    private final EventsTask _eventsTask;
    private final SyncManager _syncManager;
    private final CloseableHttpClient _httpclient;
    private final UserStorageWrapper _userStorageWrapper;
    private final ImpressionsSender _impressionsSender;
    private final URI _rootTarget;
    private final URI _eventsRootTarget;
    private final UniqueKeysTracker _uniqueKeysTracker;

    public SplitFactoryImpl(String apiToken, SplitClientConfig config) throws URISyntaxException {
        this._userStorageWrapper = null;
        this._operationMode = config.operationMode();
        this._startTime = System.currentTimeMillis();
        this._apiToken = apiToken;
        this._apiKeyCounter = ApiKeyCounter.getApiKeyCounterInstance();
        this._apiKeyCounter.add(apiToken);
        this._sdkMetadata = this.createSdkMetadata(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion);
        InMemoryTelemetryStorage telemetryStorage = new InMemoryTelemetryStorage();
        this._telemetryStorageProducer = telemetryStorage;
        if (config.blockUntilReady() == -1) {
            _log.warn("no setBlockUntilReadyTimeout parameter has been set - incorrect control treatments could be logged\u201d if no ready config has been set when building factory");
        }
        this._gates = new SDKReadinessGates();
        this._httpclient = SplitFactoryImpl.buildHttpClient(apiToken, config, this._sdkMetadata);
        this._rootTarget = URI.create(config.endpoint());
        this._eventsRootTarget = URI.create(config.eventsEndpoint());
        SegmentCacheInMemoryImpl segmentCache = new SegmentCacheInMemoryImpl();
        InMemoryCacheImp splitCache = new InMemoryCacheImp();
        InMemoryImpressionsStorage impressionsStorage = new InMemoryImpressionsStorage(config.impressionsQueueSize());
        this._splitCache = splitCache;
        this._segmentCache = segmentCache;
        this._telemetrySynchronizer = new TelemetryInMemorySubmitter(this._httpclient, URI.create(config.telemetryURL()), telemetryStorage, splitCache, segmentCache, telemetryStorage, this._startTime);
        this._segmentSynchronizationTaskImp = this.buildSegments(config, segmentCache, splitCache);
        this._splitFetcher = this.buildSplitFetcher(splitCache, splitCache);
        this._splitSynchronizationTask = new SplitSynchronizationTask(this._splitFetcher, splitCache, config.featuresRefreshRate());
        this._impressionsSender = HttpImpressionsSender.create(this._httpclient, URI.create(config.eventsEndpoint()), config.impressionsMode(), this._telemetryStorageProducer);
        this._uniqueKeysTracker = this.createUniqueKeysTracker(config);
        this._impressionsManager = this.buildImpressionsManager(config, impressionsStorage, impressionsStorage);
        InMemoryEventsStorage eventsStorage = new InMemoryEventsStorage(config.eventsQueueSize(), this._telemetryStorageProducer);
        EventsSender eventsSender = EventsSender.create(this._httpclient, this._eventsRootTarget, this._telemetryStorageProducer);
        this._eventsTask = EventsTask.create(config.eventSendIntervalInMillis(), eventsStorage, eventsSender);
        this._telemetrySyncTask = new TelemetrySyncTask(config.get_telemetryRefreshRate(), this._telemetrySynchronizer);
        this._evaluator = new EvaluatorImp(splitCache, segmentCache);
        this._client = new SplitClientImpl(this, splitCache, this._impressionsManager, eventsStorage, config, this._gates, this._evaluator, this._telemetryStorageProducer, this._telemetryStorageProducer);
        this._manager = new SplitManagerImpl(splitCache, config, this._gates, this._telemetryStorageProducer);
        SplitTasks splitTasks = SplitTasks.build(this._splitSynchronizationTask, this._segmentSynchronizationTaskImp, this._impressionsManager, this._eventsTask, this._telemetrySyncTask, this._uniqueKeysTracker);
        SplitAPI splitAPI = SplitAPI.build(this._httpclient, SplitFactoryImpl.buildSSEdHttpClient(apiToken, config, this._sdkMetadata));
        this._syncManager = SyncManagerImp.build(splitTasks, this._splitFetcher, splitCache, splitAPI, segmentCache, this._gates, this._telemetryStorageProducer, this._telemetrySynchronizer, config);
        this._syncManager.start();
        if (config.destroyOnShutDown()) {
            Thread shutdown = new Thread(() -> this.destroy());
            shutdown.setName("split-destroy-worker");
            Runtime.getRuntime().addShutdownHook(shutdown);
        }
    }

    protected SplitFactoryImpl(String apiToken, SplitClientConfig config, CustomStorageWrapper customStorageWrapper) throws URISyntaxException {
        this._segmentSynchronizationTaskImp = null;
        this._splitFetcher = null;
        this._splitSynchronizationTask = null;
        this._eventsTask = null;
        this._httpclient = null;
        this._rootTarget = null;
        this._eventsRootTarget = null;
        Metadata metadata = new Metadata(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion);
        this._userStorageWrapper = new UserStorageWrapper(customStorageWrapper);
        UserCustomSegmentAdapterConsumer userCustomSegmentAdapterConsumer = new UserCustomSegmentAdapterConsumer(customStorageWrapper);
        UserCustomSplitAdapterConsumer userCustomSplitAdapterConsumer = new UserCustomSplitAdapterConsumer(customStorageWrapper);
        UserCustomImpressionAdapterConsumer userCustomImpressionAdapterConsumer = new UserCustomImpressionAdapterConsumer();
        UserCustomImpressionAdapterProducer userCustomImpressionAdapterProducer = new UserCustomImpressionAdapterProducer(customStorageWrapper, metadata);
        UserCustomEventAdapterProducer userCustomEventAdapterProducer = new UserCustomEventAdapterProducer(customStorageWrapper, metadata);
        this._operationMode = config.operationMode();
        this._sdkMetadata = this.createSdkMetadata(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion);
        this._startTime = System.currentTimeMillis();
        this._apiToken = apiToken;
        this._apiKeyCounter = ApiKeyCounter.getApiKeyCounterInstance();
        this._apiKeyCounter.add(apiToken);
        this._telemetryStorageProducer = new UserCustomTelemetryAdapterProducer(customStorageWrapper, this._sdkMetadata);
        this._splitCache = userCustomSplitAdapterConsumer;
        this._segmentCache = userCustomSegmentAdapterConsumer;
        if (config.blockUntilReady() == -1) {
            _log.warn("no setBlockUntilReadyTimeout parameter has been set - incorrect control treatments could be logged\u201d if no ready config has been set when building factory");
        }
        this._gates = new SDKReadinessGates();
        this._telemetrySynchronizer = new TelemetryConsumerSubmitter(customStorageWrapper, this._sdkMetadata);
        this._evaluator = new EvaluatorImp(userCustomSplitAdapterConsumer, userCustomSegmentAdapterConsumer);
        this._impressionsSender = PluggableImpressionSender.create(customStorageWrapper);
        this._uniqueKeysTracker = this.createUniqueKeysTracker(config);
        this._impressionsManager = this.buildImpressionsManager(config, userCustomImpressionAdapterConsumer, userCustomImpressionAdapterProducer);
        this._telemetrySyncTask = new TelemetrySyncTask(config.get_telemetryRefreshRate(), this._telemetrySynchronizer);
        SplitTasks splitTasks = SplitTasks.build(null, null, this._impressionsManager, null, this._telemetrySyncTask, this._uniqueKeysTracker);
        ConsumerSynchronizer synchronizer = new ConsumerSynchronizer(splitTasks);
        this._client = new SplitClientImpl(this, userCustomSplitAdapterConsumer, this._impressionsManager, userCustomEventAdapterProducer, config, this._gates, this._evaluator, this._telemetryStorageProducer, this._telemetryStorageProducer);
        this._syncManager = new ConsumerSyncManager(synchronizer);
        this._syncManager.start();
        this._manager = new SplitManagerImpl(userCustomSplitAdapterConsumer, config, this._gates, this._telemetryStorageProducer);
        this.manageSdkReady(config);
    }

    protected SplitFactoryImpl(SplitClientConfig config) throws URISyntaxException {
        this._userStorageWrapper = null;
        this._apiToken = "localhost";
        this._apiKeyCounter = ApiKeyCounter.getApiKeyCounterInstance();
        this._apiKeyCounter.add("localhost");
        this._sdkMetadata = this.createSdkMetadata(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion);
        this._telemetrySynchronizer = null;
        this._telemetrySyncTask = null;
        this._eventsTask = null;
        this._httpclient = null;
        this._impressionsSender = null;
        this._rootTarget = null;
        this._eventsRootTarget = null;
        this._uniqueKeysTracker = null;
        this._telemetryStorageProducer = new NoopTelemetryStorage();
        SegmentCacheInMemoryImpl segmentCache = new SegmentCacheInMemoryImpl();
        InMemoryCacheImp splitCache = new InMemoryCacheImp();
        this._splitCache = splitCache;
        this._gates = new SDKReadinessGates();
        this._segmentCache = segmentCache;
        SegmentChangeFetcher segmentChangeFetcher = new LocalhostSegmentFetcherNoop();
        if (config.segmentDirectory() != null) {
            segmentChangeFetcher = new LocalhostSegmentChangeFetcher(config.segmentDirectory());
        }
        this._segmentSynchronizationTaskImp = new SegmentSynchronizationTaskImp(segmentChangeFetcher, config.segmentsRefreshRate(), config.numThreadsForSegmentFetch(), segmentCache, this._telemetryStorageProducer, this._splitCache);
        LocalhostSplitChangeFetcher splitChangeFetcher = new LocalhostSplitChangeFetcher(config.splitFile());
        SplitParser splitParser = new SplitParser();
        this._splitFetcher = new SplitFetcherImp(splitChangeFetcher, splitParser, this._splitCache, splitCache, this._telemetryStorageProducer);
        this._splitSynchronizationTask = new SplitSynchronizationTask(this._splitFetcher, splitCache, config.featuresRefreshRate());
        this._impressionsManager = new ImpressionsManager.NoOpImpressionsManager();
        SplitTasks splitTasks = SplitTasks.build(this._splitSynchronizationTask, this._segmentSynchronizationTaskImp, this._impressionsManager, null, null, null);
        this._evaluator = new EvaluatorImp(splitCache, segmentCache);
        NoopEventsStorageImp eventsStorage = new NoopEventsStorageImp();
        this._client = new SplitClientImpl(this, splitCache, this._impressionsManager, eventsStorage, config, this._gates, this._evaluator, this._telemetryStorageProducer, this._telemetryStorageProducer);
        LocalhostSynchronizer synchronizer = new LocalhostSynchronizer(splitTasks, this._splitFetcher, config.localhostRefreshEnabled());
        this._manager = new SplitManagerImpl(splitCache, config, this._gates, this._telemetryStorageProducer);
        this._syncManager = new LocalhostSyncManager(synchronizer, this._gates);
        this._syncManager.start();
        if (config.destroyOnShutDown()) {
            Thread shutdown = new Thread(() -> this.destroy());
            shutdown.setName("split-destroy-worker");
            Runtime.getRuntime().addShutdownHook(shutdown);
        }
    }

    @Override
    public SplitClient client() {
        return this._client;
    }

    @Override
    public SplitManager manager() {
        return this._manager;
    }

    @Override
    public synchronized void destroy() {
        if (this.isTerminated) {
            return;
        }
        try {
            long splitCount = this._splitCache.getAll().stream().count();
            long segmentCount = this._segmentCache.getSegmentCount();
            long segmentKeyCount = this._segmentCache.getKeyCount();
            _log.info("Shutdown called for split");
            this._syncManager.shutdown(splitCount, segmentCount, segmentKeyCount);
            _log.info("Successful shutdown of syncManager");
            if (OperationMode.STANDALONE.equals((Object)this._operationMode)) {
                this._telemetryStorageProducer.recordSessionLength(System.currentTimeMillis() - this._startTime);
            } else if (OperationMode.CONSUMER.equals((Object)this._operationMode)) {
                this._userStorageWrapper.disconnect();
            }
        }
        catch (IOException e) {
            _log.error("We could not shutdown split", (Throwable)e);
        }
        this._apiKeyCounter.remove(this._apiToken);
        this.isTerminated = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.isTerminated;
    }

    private static CloseableHttpClient buildHttpClient(String apiToken, SplitClientConfig config, SDKMetadata sdkMetadata) {
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(TLS.V_1_1, TLS.V_1_2).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(config.connectionTimeout())).setCookieSpec("strict").build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds(config.readTimeout())).build()).setValidateAfterInactivity(TimeValue.ofMilliseconds(config.validateAfterInactivityInMillis())).build();
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(20);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).addRequestInterceptorLast(AuthorizationInterceptorFilter.instance(apiToken)).addRequestInterceptorLast(SdkMetadataInterceptorFilter.instance(sdkMetadata)).addRequestInterceptorLast(new GzipEncoderRequestInterceptor()).addResponseInterceptorLast(new GzipDecoderResponseInterceptor());
        if (config.proxy() != null) {
            httpClientbuilder = SplitFactoryImpl.setupProxy(httpClientbuilder, config);
        }
        return httpClientbuilder.build();
    }

    private static CloseableHttpClient buildSSEdHttpClient(String apiToken, SplitClientConfig config, SDKMetadata sdkMetadata) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(30000L)).build();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(TLS.V_1_1, TLS.V_1_2).build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds(70000L)).build()).build();
        cm.setMaxTotal(1);
        cm.setDefaultMaxPerRoute(1);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).addRequestInterceptorLast(SdkMetadataInterceptorFilter.instance(sdkMetadata)).addRequestInterceptorLast(ClientKeyInterceptorFilter.instance(apiToken));
        if (config.proxy() != null) {
            httpClientbuilder = SplitFactoryImpl.setupProxy(httpClientbuilder, config);
        }
        return httpClientbuilder.build();
    }

    private static HttpClientBuilder setupProxy(HttpClientBuilder httpClientbuilder, SplitClientConfig config) {
        _log.info("Initializing Split SDK with proxy settings");
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(config.proxy());
        httpClientbuilder.setRoutePlanner(routePlanner);
        if (config.proxyUsername() != null && config.proxyPassword() != null) {
            _log.debug("Proxy setup using credentials");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            AuthScope siteScope = new AuthScope(config.proxy().getHostName(), config.proxy().getPort());
            UsernamePasswordCredentials siteCreds = new UsernamePasswordCredentials(config.proxyUsername(), config.proxyPassword().toCharArray());
            credsProvider.setCredentials(siteScope, siteCreds);
            httpClientbuilder.setDefaultCredentialsProvider(credsProvider);
        }
        return httpClientbuilder;
    }

    private SegmentSynchronizationTaskImp buildSegments(SplitClientConfig config, SegmentCacheProducer segmentCacheProducer, SplitCacheConsumer splitCacheConsumer) throws URISyntaxException {
        HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(this._httpclient, this._rootTarget, this._telemetryStorageProducer);
        return new SegmentSynchronizationTaskImp(segmentChangeFetcher, config.segmentsRefreshRate(), config.numThreadsForSegmentFetch(), segmentCacheProducer, this._telemetryStorageProducer, splitCacheConsumer);
    }

    private SplitFetcher buildSplitFetcher(SplitCacheConsumer splitCacheConsumer, SplitCacheProducer splitCacheProducer) throws URISyntaxException {
        HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(this._httpclient, this._rootTarget, this._telemetryStorageProducer);
        SplitParser splitParser = new SplitParser();
        return new SplitFetcherImp(splitChangeFetcher, splitParser, splitCacheConsumer, splitCacheProducer, this._telemetryStorageProducer);
    }

    private ImpressionsManagerImpl buildImpressionsManager(SplitClientConfig config, ImpressionsStorageConsumer impressionsStorageConsumer, ImpressionsStorageProducer impressionsStorageProducer) throws URISyntaxException {
        ArrayList<ImpressionListener> impressionListeners = new ArrayList<ImpressionListener>();
        if (config.integrationsConfig() != null) {
            config.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.ASYNC).stream().map(l -> AsynchronousImpressionListener.build(l.listener(), l.queueSize())).collect(Collectors.toCollection(() -> impressionListeners));
            config.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.SYNC).stream().map(IntegrationsConfig.ImpressionListenerWithMeta::listener).collect(Collectors.toCollection(() -> impressionListeners));
        }
        ProcessImpressionStrategy processImpressionStrategy = null;
        ImpressionCounter counter = null;
        ImpressionListener.FederatedImpressionListener listener = null != impressionListeners && !impressionListeners.isEmpty() ? new ImpressionListener.FederatedImpressionListener(impressionListeners) : null;
        switch (config.impressionsMode()) {
            case OPTIMIZED: {
                counter = new ImpressionCounter();
                ImpressionObserver impressionObserver = new ImpressionObserver(config.getLastSeenCacheSize());
                processImpressionStrategy = new ProcessImpressionOptimized(listener != null, impressionObserver, counter, this._telemetryStorageProducer);
                break;
            }
            case DEBUG: {
                ImpressionObserver impressionObserver = new ImpressionObserver(config.getLastSeenCacheSize());
                processImpressionStrategy = new ProcessImpressionDebug(listener != null, impressionObserver);
                break;
            }
            case NONE: {
                counter = new ImpressionCounter();
                processImpressionStrategy = new ProcessImpressionNone(listener != null, this._uniqueKeysTracker, counter);
            }
        }
        return ImpressionsManagerImpl.instance(config, this._telemetryStorageProducer, impressionsStorageConsumer, impressionsStorageProducer, this._impressionsSender, processImpressionStrategy, counter, listener);
    }

    private SDKMetadata createSdkMetadata(boolean ipAddressEnabled, String splitSdkVersion) {
        String machineName = "";
        String ip = "";
        if (ipAddressEnabled) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                machineName = localHost.getHostName();
                ip = localHost.getHostAddress();
            }
            catch (Exception e) {
                _log.error("Could not resolve InetAddress", (Throwable)e);
            }
        }
        return new SDKMetadata(splitSdkVersion, ip, machineName);
    }

    private void manageSdkReady(SplitClientConfig config) {
        ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("SPLIT-SDKReadyForConsumer-%d").setDaemon(true).build());
        executorService.submit(() -> {
            while (!this._userStorageWrapper.connect()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    _log.warn("Sdk Initializer thread interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            this._gates.sdkInternalReady();
            this._telemetrySynchronizer.synchronizeConfig(config, System.currentTimeMillis(), ApiKeyCounter.getApiKeyCounterInstance().getFactoryInstances(), new ArrayList<String>());
        });
    }

    private UniqueKeysTracker createUniqueKeysTracker(SplitClientConfig config) {
        if (config.impressionsMode().equals((Object)ImpressionsManager.Mode.NONE)) {
            int uniqueKeysRefreshRate = config.operationMode().equals((Object)OperationMode.STANDALONE) ? config.uniqueKeysRefreshRateInMemory() : config.uniqueKeysRefreshRateRedis();
            return new UniqueKeysTrackerImp(this._telemetrySynchronizer, uniqueKeysRefreshRate, config.filterUniqueKeysRefreshRate());
        }
        return null;
    }
}

