/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.dtos.UniqueKeys;
import io.split.client.impressions.UniqueKeysTracker;
import io.split.client.impressions.filters.BloomFilterImp;
import io.split.client.impressions.filters.FilterAdapter;
import io.split.client.impressions.filters.FilterAdapterImpl;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class UniqueKeysTrackerImp
implements UniqueKeysTracker {
    private static final Logger _log = LoggerFactory.getLogger(UniqueKeysTrackerImp.class);
    private static final double MARGIN_ERROR = 0.01;
    private static final int MAX_AMOUNT_OF_TRACKED_UNIQUE_KEYS = 30000;
    private static final int MAX_AMOUNT_OF_KEYS = 10000000;
    private FilterAdapter filterAdapter;
    private final TelemetrySynchronizer _telemetrySynchronizer;
    private final ScheduledExecutorService _uniqueKeysSyncScheduledExecutorService;
    private final ScheduledExecutorService _cleanFilterScheduledExecutorService;
    private final ConcurrentHashMap<String, HashSet<String>> uniqueKeysTracker;
    private final int _uniqueKeysRefreshRate;
    private final int _filterRefreshRate;
    private static final Logger _logger = LoggerFactory.getLogger(UniqueKeysTrackerImp.class);

    public UniqueKeysTrackerImp(TelemetrySynchronizer telemetrySynchronizer, int uniqueKeysRefreshRate, int filterRefreshRate) {
        BloomFilterImp bloomFilter = new BloomFilterImp(10000000, 0.01);
        this.filterAdapter = new FilterAdapterImpl(bloomFilter);
        this.uniqueKeysTracker = new ConcurrentHashMap();
        this._telemetrySynchronizer = telemetrySynchronizer;
        this._uniqueKeysRefreshRate = uniqueKeysRefreshRate;
        this._filterRefreshRate = filterRefreshRate;
        ThreadFactory uniqueKeysSyncThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("UniqueKeys-sync-%d").build();
        ThreadFactory filterThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Filter-%d").build();
        this._uniqueKeysSyncScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(uniqueKeysSyncThreadFactory);
        this._cleanFilterScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(filterThreadFactory);
    }

    @Override
    public synchronized boolean track(String featureName, String key) {
        if (!this.filterAdapter.add(featureName, key)) {
            _logger.debug("The feature " + featureName + " and key " + key + " exist in the UniqueKeysTracker");
            return false;
        }
        HashSet<String> value = new HashSet<String>();
        if (this.uniqueKeysTracker.containsKey(featureName)) {
            value = this.uniqueKeysTracker.get(featureName);
        }
        value.add(key);
        this.uniqueKeysTracker.put(featureName, value);
        _logger.debug("The feature " + featureName + " and key " + key + " was added");
        if (this.uniqueKeysTracker.size() == 30000) {
            _logger.warn("The UniqueKeysTracker size reached the maximum limit");
            try {
                this.sendUniqueKeys();
            }
            catch (Exception e) {
                _log.error("Error sending unique keys.", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public void start() {
        this.scheduleWithFixedDelay(this._uniqueKeysSyncScheduledExecutorService, this._uniqueKeysRefreshRate, new ExecuteSendUniqueKeys());
        this.scheduleWithFixedDelay(this._cleanFilterScheduledExecutorService, this._filterRefreshRate, new ExecuteCleanFilter());
    }

    private void scheduleWithFixedDelay(ScheduledExecutorService scheduledExecutorService, int refreshRate, ExecuteUniqueKeysAction executeUniqueKeysAction) {
        scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                executeUniqueKeysAction.execute();
            }
            catch (Exception e) {
                _log.error("Error executing an Unique Key Action.", (Throwable)e);
            }
        }, refreshRate, refreshRate, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        try {
            this.sendUniqueKeys();
        }
        catch (Exception e) {
            _log.error("Error sending unique keys.");
        }
        this._uniqueKeysSyncScheduledExecutorService.shutdown();
        this._cleanFilterScheduledExecutorService.shutdown();
    }

    public HashMap<String, HashSet<String>> popAll() {
        HashMap<String, HashSet<String>> toReturn = new HashMap<String, HashSet<String>>();
        for (String key : this.uniqueKeysTracker.keySet()) {
            HashSet<String> value = this.uniqueKeysTracker.remove(key);
            toReturn.put(key, value);
        }
        return toReturn;
    }

    private void sendUniqueKeys() {
        if (this.uniqueKeysTracker.size() == 0) {
            _log.warn("The Unique Keys Tracker is empty");
            return;
        }
        HashMap<String, HashSet<String>> uniqueKeysHashMap = this.popAll();
        ArrayList<UniqueKeys.UniqueKey> uniqueKeysFromPopAll = new ArrayList<UniqueKeys.UniqueKey>();
        for (String feature : uniqueKeysHashMap.keySet()) {
            UniqueKeys.UniqueKey uniqueKey = new UniqueKeys.UniqueKey(feature, new ArrayList<String>((Collection)uniqueKeysHashMap.get(feature)));
            uniqueKeysFromPopAll.add(uniqueKey);
        }
        this._telemetrySynchronizer.synchronizeUniqueKeys(new UniqueKeys(uniqueKeysFromPopAll));
    }

    private class ExecuteSendUniqueKeys
    implements ExecuteUniqueKeysAction {
        private ExecuteSendUniqueKeys() {
        }

        @Override
        public void execute() {
            UniqueKeysTrackerImp.this.sendUniqueKeys();
        }
    }

    private class ExecuteCleanFilter
    implements ExecuteUniqueKeysAction {
        private ExecuteCleanFilter() {
        }

        @Override
        public void execute() {
            UniqueKeysTrackerImp.this.filterAdapter.clear();
        }
    }

    private static interface ExecuteUniqueKeysAction {
        public void execute();
    }
}

