/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.client.events.EventsTask;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.impressions.UniqueKeysTracker;
import io.split.client.utils.Json;
import io.split.engine.common.Backoff;
import io.split.engine.common.FastlyHeadersCaptor;
import io.split.engine.common.FetchOptions;
import io.split.engine.common.SplitTasks;
import io.split.engine.common.Synchronizer;
import io.split.engine.experiments.FetchResult;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitSynchronizationTask;
import io.split.engine.segments.SegmentFetcher;
import io.split.engine.segments.SegmentSynchronizationTask;
import io.split.storages.SegmentCacheProducer;
import io.split.storages.SplitCacheProducer;
import io.split.telemetry.synchronizer.TelemetrySyncTask;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class SynchronizerImp
implements Synchronizer {
    private static final long ON_DEMAND_FETCH_BACKOFF_BASE_MS = new Long(10000L);
    private static final long ON_DEMAND_FETCH_BACKOFF_MAX_WAIT_MS = new Long(60000L);
    private static final int ON_DEMAND_FETCH_BACKOFF_MAX_RETRIES = 10;
    private static final Logger _log = LoggerFactory.getLogger(Synchronizer.class);
    private final SplitSynchronizationTask _splitSynchronizationTask;
    private final SplitFetcher _splitFetcher;
    private final SegmentSynchronizationTask _segmentSynchronizationTaskImp;
    private final SplitCacheProducer _splitCacheProducer;
    private final SegmentCacheProducer segmentCacheProducer;
    private final ImpressionsManager _impressionManager;
    private final EventsTask _eventsTask;
    private final TelemetrySyncTask _telemetrySyncTask;
    private final UniqueKeysTracker _uniqueKeysTracker;
    private final int _onDemandFetchRetryDelayMs;
    private final int _onDemandFetchMaxRetries;
    private final int _failedAttemptsBeforeLogging;
    private final boolean _cdnResponseHeadersLogging;

    public SynchronizerImp(SplitTasks splitTasks, SplitFetcher splitFetcher, SplitCacheProducer splitCacheProducer, SegmentCacheProducer segmentCacheProducer, int onDemandFetchRetryDelayMs, int onDemandFetchMaxRetries, int failedAttemptsBeforeLogging, boolean cdnResponseHeadersLogging) {
        this._splitSynchronizationTask = Preconditions.checkNotNull(splitTasks.getSplitSynchronizationTask());
        this._splitFetcher = Preconditions.checkNotNull(splitFetcher);
        this._segmentSynchronizationTaskImp = Preconditions.checkNotNull(splitTasks.getSegmentSynchronizationTask());
        this._splitCacheProducer = Preconditions.checkNotNull(splitCacheProducer);
        this.segmentCacheProducer = Preconditions.checkNotNull(segmentCacheProducer);
        this._onDemandFetchRetryDelayMs = Preconditions.checkNotNull(onDemandFetchRetryDelayMs);
        this._cdnResponseHeadersLogging = cdnResponseHeadersLogging;
        this._onDemandFetchMaxRetries = onDemandFetchMaxRetries;
        this._failedAttemptsBeforeLogging = failedAttemptsBeforeLogging;
        this._impressionManager = splitTasks.getImpressionManager();
        this._eventsTask = splitTasks.getEventsTask();
        this._telemetrySyncTask = splitTasks.getTelemetrySyncTask();
        this._uniqueKeysTracker = splitTasks.getUniqueKeysTracker();
    }

    @Override
    public boolean syncAll() {
        FetchResult fetchResult = this._splitFetcher.forceRefresh(new FetchOptions.Builder().cacheControlHeaders(true).build());
        return fetchResult.isSuccess() && this._segmentSynchronizationTaskImp.fetchAllSynchronous();
    }

    @Override
    public void startPeriodicFetching() {
        _log.debug("Starting Periodic Fetching ...");
        this._splitSynchronizationTask.start();
        this._segmentSynchronizationTaskImp.start();
    }

    @Override
    public void stopPeriodicFetching() {
        _log.debug("Stop Periodic Fetching ...");
        this._splitSynchronizationTask.stop();
        this._segmentSynchronizationTaskImp.stop();
    }

    private SyncResult attemptSplitsSync(long targetChangeNumber, FetchOptions opts, Function<Void, Long> nextWaitMs, int maxRetries) {
        int remainingAttempts = maxRetries;
        while (true) {
            --remainingAttempts;
            FetchResult fetchResult = this._splitFetcher.forceRefresh(opts);
            if (targetChangeNumber <= this._splitCacheProducer.getChangeNumber()) {
                return new SyncResult(true, remainingAttempts, fetchResult);
            }
            if (remainingAttempts <= 0) {
                return new SyncResult(false, remainingAttempts, fetchResult);
            }
            try {
                long howLong = nextWaitMs.apply(null);
                Thread.sleep(howLong);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                _log.debug("Error trying to sleep current Thread.");
                continue;
            }
            break;
        }
    }

    private void logCdnHeaders(String prefix, int maxRetries, int remainingAttempts, List<Map<String, String>> headers) {
        if (maxRetries - remainingAttempts > this._failedAttemptsBeforeLogging) {
            _log.info(String.format("%s: CDN Debug headers: %s", prefix, Json.toJson(headers)));
        }
    }

    @Override
    public void refreshSplits(Long targetChangeNumber) {
        if (targetChangeNumber <= this._splitCacheProducer.getChangeNumber()) {
            return;
        }
        FastlyHeadersCaptor captor = new FastlyHeadersCaptor();
        FetchOptions opts = new FetchOptions.Builder().cacheControlHeaders(true).fastlyDebugHeader(this._cdnResponseHeadersLogging).responseHeadersCallback(this._cdnResponseHeadersLogging ? captor::handle : null).build();
        SyncResult regularResult = this.attemptSplitsSync(targetChangeNumber, opts, discard -> this._onDemandFetchRetryDelayMs, this._onDemandFetchMaxRetries);
        int attempts = this._onDemandFetchMaxRetries - regularResult.remainingAttempts();
        if (regularResult.success()) {
            _log.debug(String.format("Refresh completed in %s attempts.", attempts));
            if (this._cdnResponseHeadersLogging) {
                this.logCdnHeaders("[splits]", this._onDemandFetchMaxRetries, regularResult.remainingAttempts(), captor.get());
            }
            regularResult._fetchResult.getSegments().stream().forEach(segmentName -> this.forceRefreshSegment((String)segmentName));
            return;
        }
        _log.info(String.format("No changes fetched after %s attempts. Will retry bypassing CDN.", attempts));
        FetchOptions withCdnBypass = new FetchOptions.Builder(opts).targetChangeNumber(targetChangeNumber).build();
        Backoff backoff = new Backoff(ON_DEMAND_FETCH_BACKOFF_BASE_MS, ON_DEMAND_FETCH_BACKOFF_MAX_WAIT_MS);
        SyncResult withCDNBypassed = this.attemptSplitsSync(targetChangeNumber, withCdnBypass, discard -> backoff.interval(), 10);
        int withoutCDNAttempts = 10 - withCDNBypassed._remainingAttempts;
        if (withCDNBypassed.success()) {
            _log.debug(String.format("Refresh completed bypassing the CDN in %s attempts.", withoutCDNAttempts));
            withCDNBypassed._fetchResult.getSegments().stream().forEach(segmentName -> this.forceRefreshSegment((String)segmentName));
        } else {
            _log.debug(String.format("No changes fetched after %s attempts with CDN bypassed.", withoutCDNAttempts));
        }
        if (this._cdnResponseHeadersLogging) {
            this.logCdnHeaders("[splits]", this._onDemandFetchMaxRetries + 10, withCDNBypassed.remainingAttempts(), captor.get());
        }
    }

    @Override
    public void localKillSplit(String splitName, String defaultTreatment, long newChangeNumber) {
        if (newChangeNumber > this._splitCacheProducer.getChangeNumber()) {
            this._splitCacheProducer.kill(splitName, defaultTreatment, newChangeNumber);
            this.refreshSplits(newChangeNumber);
        }
    }

    public SyncResult attemptSegmentSync(String segmentName, long targetChangeNumber, FetchOptions opts, Function<Void, Long> nextWaitMs, int maxRetries) {
        int remainingAttempts = maxRetries;
        SegmentFetcher fetcher = this._segmentSynchronizationTaskImp.getFetcher(segmentName);
        Preconditions.checkNotNull(fetcher);
        while (true) {
            --remainingAttempts;
            fetcher.fetch(opts);
            if (targetChangeNumber <= this.segmentCacheProducer.getChangeNumber(segmentName)) {
                return new SyncResult(true, remainingAttempts, new FetchResult(false, new HashSet<String>()));
            }
            if (remainingAttempts <= 0) {
                return new SyncResult(false, remainingAttempts, new FetchResult(false, new HashSet<String>()));
            }
            try {
                long howLong = nextWaitMs.apply(null);
                Thread.sleep(howLong);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                _log.debug("Error trying to sleep current Thread.");
                continue;
            }
            break;
        }
    }

    @Override
    public void refreshSegment(String segmentName, Long targetChangeNumber) {
        if (targetChangeNumber <= this.segmentCacheProducer.getChangeNumber(segmentName)) {
            return;
        }
        FastlyHeadersCaptor captor = new FastlyHeadersCaptor();
        FetchOptions opts = new FetchOptions.Builder().cacheControlHeaders(true).fastlyDebugHeader(this._cdnResponseHeadersLogging).responseHeadersCallback(this._cdnResponseHeadersLogging ? captor::handle : null).build();
        SyncResult regularResult = this.attemptSegmentSync(segmentName, targetChangeNumber, opts, discard -> this._onDemandFetchRetryDelayMs, this._onDemandFetchMaxRetries);
        int attempts = this._onDemandFetchMaxRetries - regularResult.remainingAttempts();
        if (regularResult.success()) {
            _log.debug(String.format("Segment %s refresh completed in %s attempts.", segmentName, attempts));
            if (this._cdnResponseHeadersLogging) {
                this.logCdnHeaders(String.format("[segment/%s]", segmentName), this._onDemandFetchMaxRetries, regularResult.remainingAttempts(), captor.get());
            }
            return;
        }
        _log.info(String.format("No changes fetched for segment %s after %s attempts. Will retry bypassing CDN.", segmentName, attempts));
        FetchOptions withCdnBypass = new FetchOptions.Builder(opts).targetChangeNumber(targetChangeNumber).build();
        Backoff backoff = new Backoff(ON_DEMAND_FETCH_BACKOFF_BASE_MS, ON_DEMAND_FETCH_BACKOFF_MAX_WAIT_MS);
        SyncResult withCDNBypassed = this.attemptSegmentSync(segmentName, targetChangeNumber, withCdnBypass, discard -> backoff.interval(), 10);
        int withoutCDNAttempts = 10 - withCDNBypassed._remainingAttempts;
        if (withCDNBypassed.success()) {
            _log.debug(String.format("Segment %s refresh completed bypassing the CDN in %s attempts.", segmentName, withoutCDNAttempts));
        } else {
            _log.debug(String.format("No changes fetched for segment %s after %s attempts with CDN bypassed.", segmentName, withoutCDNAttempts));
        }
        if (this._cdnResponseHeadersLogging) {
            this.logCdnHeaders(String.format("[segment/%s]", segmentName), this._onDemandFetchMaxRetries + 10, withCDNBypassed.remainingAttempts(), captor.get());
        }
    }

    @Override
    public void startPeriodicDataRecording() {
        try {
            this._impressionManager.start();
        }
        catch (Exception e) {
            _log.error("Error trying to init Impression Manager synchronizer task.", (Throwable)e);
        }
        if (this._uniqueKeysTracker != null) {
            try {
                this._uniqueKeysTracker.start();
            }
            catch (Exception e) {
                _log.error("Error trying to init Unique Keys Tracker synchronizer task.", (Throwable)e);
            }
        }
        try {
            this._eventsTask.start();
        }
        catch (Exception e) {
            _log.error("Error trying to init Events synchronizer task.", (Throwable)e);
        }
        try {
            this._telemetrySyncTask.startScheduledTask();
        }
        catch (Exception e) {
            _log.error("Error trying to Telemetry synchronizer task.", (Throwable)e);
        }
    }

    @Override
    public void stopPeriodicDataRecording(long splitCount, long segmentCount, long segmentKeyCount) {
        this._impressionManager.close();
        _log.info("Successful shutdown of impressions manager");
        if (this._uniqueKeysTracker != null) {
            this._uniqueKeysTracker.stop();
            _log.info("Successful stop of UniqueKeysTracker");
        }
        this._eventsTask.close();
        _log.info("Successful shutdown of eventsTask");
        this._telemetrySyncTask.stopScheduledTask(splitCount, segmentCount, segmentKeyCount);
        _log.info("Successful shutdown of telemetry sync task");
    }

    private void forceRefreshSegment(String segmentName) {
        SegmentFetcher segmentFetcher = this._segmentSynchronizationTaskImp.getFetcher(segmentName);
        segmentFetcher.fetch(new FetchOptions.Builder().build());
    }

    private static class SyncResult {
        private final boolean _success;
        private final int _remainingAttempts;
        private final FetchResult _fetchResult;

        SyncResult(boolean success, int remainingAttempts, FetchResult fetchResult) {
            this._success = success;
            this._remainingAttempts = remainingAttempts;
            this._fetchResult = fetchResult;
        }

        public boolean success() {
            return this._success;
        }

        public int remainingAttempts() {
            return this._remainingAttempts;
        }
    }
}

