/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.adapters;

import io.split.storages.SegmentCacheConsumer;
import io.split.storages.pluggable.domain.PrefixAdapter;
import io.split.storages.pluggable.domain.UserStorageWrapper;
import io.split.storages.pluggable.utils.Helper;
import java.util.Set;
import pluggable.CustomStorageWrapper;
import split.com.google.common.base.Preconditions;

public class UserCustomSegmentAdapterConsumer
implements SegmentCacheConsumer {
    private final UserStorageWrapper _userStorageWrapper;

    public UserCustomSegmentAdapterConsumer(CustomStorageWrapper customStorageWrapper) {
        this._userStorageWrapper = new UserStorageWrapper(Preconditions.checkNotNull(customStorageWrapper));
    }

    @Override
    public long getChangeNumber(String segmentName) {
        String wrapperResponse = this._userStorageWrapper.get(PrefixAdapter.buildSegment(segmentName));
        return Helper.responseToLong(wrapperResponse, -1L);
    }

    @Override
    public boolean isInSegment(String segmentName, String key) {
        return this._userStorageWrapper.itemContains(PrefixAdapter.buildSegment(segmentName), key);
    }

    @Override
    public long getSegmentCount() {
        Set<String> keys = this._userStorageWrapper.getKeysByPrefix(PrefixAdapter.buildSegmentAll());
        return keys == null ? 0L : (long)keys.size();
    }

    @Override
    public long getKeyCount() {
        Set<String> keys = this._userStorageWrapper.getKeysByPrefix(PrefixAdapter.buildSegmentAll());
        if (keys == null) {
            return 0L;
        }
        return keys.stream().mapToLong(key -> this._userStorageWrapper.getItemsCount((String)key)).sum();
    }
}

