/*
 * Decompiled with CFR 0.152.
 */
package io.split.telemetry.synchronizer;

import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class TelemetrySyncTask {
    private static final Logger _log = LoggerFactory.getLogger(TelemetrySyncTask.class);
    private final ScheduledExecutorService _telemetrySyncScheduledExecutorService;
    private final TelemetrySynchronizer _telemetrySynchronizer;
    private final int _telemetryRefreshRate;

    public TelemetrySyncTask(int telemetryRefreshRate, TelemetrySynchronizer telemetrySynchronizer) {
        ThreadFactory telemetrySyncThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Telemetry-sync-%d").build();
        this._telemetrySynchronizer = Preconditions.checkNotNull(telemetrySynchronizer);
        this._telemetryRefreshRate = telemetryRefreshRate;
        this._telemetrySyncScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(telemetrySyncThreadFactory);
    }

    public void startScheduledTask() {
        this._telemetrySyncScheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                this._telemetrySynchronizer.synchronizeStats();
            }
            catch (Exception e) {
                _log.warn("Error sending telemetry stats.");
            }
        }, this._telemetryRefreshRate, this._telemetryRefreshRate, TimeUnit.SECONDS);
    }

    public void stopScheduledTask(long splitCount, long segmentCount, long segmentKeyCount) {
        try {
            this._telemetrySynchronizer.finalSynchronization(splitCount, segmentCount, segmentKeyCount);
        }
        catch (Exception e) {
            _log.warn("Error trying to send telemetry stats.");
        }
        this._telemetrySyncScheduledExecutorService.shutdown();
    }
}

