/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.YamlLocalhostSplitChangeFetcher;
import io.split.client.dtos.Condition;
import io.split.client.dtos.ConditionType;
import io.split.client.dtos.Split;
import io.split.client.dtos.SplitChange;
import io.split.client.dtos.Status;
import io.split.client.utils.LocalhostSanitizer;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyLocalhostSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(YamlLocalhostSplitChangeFetcher.class);
    static final String FILENAME = ".split";
    private final File _splitFile;

    public LegacyLocalhostSplitChangeFetcher(String directory) {
        if (directory == null || directory.isEmpty()) {
            directory = System.getProperty("user.home");
        }
        this._splitFile = new File(directory, FILENAME);
    }

    @Override
    public SplitChange fetch(long since, FetchOptions options) {
        SplitChange splitChange;
        BufferedReader reader = new BufferedReader(new FileReader(this._splitFile));
        try {
            SplitChange splitChange2 = new SplitChange();
            splitChange2.splits = new ArrayList<Split>();
            String line = reader.readLine();
            while (line != null) {
                String lineTrim = line.trim();
                if (!lineTrim.isEmpty() && !lineTrim.startsWith("#")) {
                    String[] featureTreatment = lineTrim.split("\\s+");
                    if (featureTreatment.length < 2 || featureTreatment.length > 3) {
                        _log.info("Ignoring line since it does not have 2 or 3 columns: " + lineTrim);
                    } else {
                        Optional<Split> splitOptional = splitChange2.splits.stream().filter(split -> split.name.equals(featureTreatment[0])).findFirst();
                        Split split2 = splitOptional.orElse(null);
                        if (split2 == null) {
                            split2 = new Split();
                            split2.name = featureTreatment[0];
                            split2.configurations = new HashMap<String, String>();
                            split2.conditions = new ArrayList<Condition>();
                        } else {
                            splitChange2.splits.remove(split2);
                        }
                        split2.status = Status.ACTIVE;
                        split2.defaultTreatment = featureTreatment[1];
                        split2.trafficTypeName = "user";
                        split2.trafficAllocation = 100;
                        split2.trafficAllocationSeed = 1;
                        Condition condition = featureTreatment.length == 2 ? LocalhostSanitizer.createCondition(null, featureTreatment[1]) : LocalhostSanitizer.createCondition(featureTreatment[2], featureTreatment[1]);
                        if (condition.conditionType != ConditionType.ROLLOUT) {
                            split2.conditions.add(0, condition);
                        } else {
                            split2.conditions.add(condition);
                        }
                        splitChange2.splits.add(split2);
                    }
                }
                line = reader.readLine();
            }
            splitChange2.till = since;
            splitChange2.since = since;
            splitChange = splitChange2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException f) {
                _log.warn("There was no file named " + this._splitFile.getPath() + " found. We created a split client that returns default treatments for all features for all of your users. If you wish to return a specific treatment for a feature, enter the name of that feature name and treatment name separated by whitespace in " + this._splitFile.getPath() + "; one pair per line. Empty lines or lines starting with '#' are considered comments", (Throwable)f);
                throw new IllegalStateException("Problem fetching splitChanges: " + f.getMessage(), f);
            }
            catch (Exception e) {
                _log.warn(String.format("Problem to fetch split change using the file %s", this._splitFile.getPath()), (Throwable)e);
                throw new IllegalStateException("Problem fetching splitChanges: " + e.getMessage(), e);
            }
        }
        reader.close();
        return splitChange;
    }
}

