/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.Condition;
import io.split.client.dtos.ConditionType;
import io.split.client.dtos.Split;
import io.split.client.dtos.SplitChange;
import io.split.client.dtos.Status;
import io.split.client.utils.LocalhostSanitizer;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.yaml.snakeyaml.Yaml;

public class YamlLocalhostSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(YamlLocalhostSplitChangeFetcher.class);
    private final File _splitFile;

    public YamlLocalhostSplitChangeFetcher(String filePath) {
        this._splitFile = new File(filePath);
    }

    @Override
    public SplitChange fetch(long since, FetchOptions options) {
        try {
            Yaml yaml = new Yaml();
            List yamlSplits = (List)yaml.load(new FileReader(this._splitFile));
            SplitChange splitChange = new SplitChange();
            splitChange.splits = new ArrayList<Split>();
            for (Map aSplit : yamlSplits) {
                Map.Entry splitAndValues = aSplit.entrySet().iterator().next();
                Optional<Split> splitOptional = splitChange.splits.stream().filter(split -> split.name.equals(splitAndValues.getKey())).findFirst();
                Split split2 = splitOptional.orElse(null);
                if (split2 == null) {
                    split2 = new Split();
                    split2.name = (String)splitAndValues.getKey();
                    split2.configurations = new HashMap<String, String>();
                    split2.conditions = new ArrayList<Condition>();
                } else {
                    splitChange.splits.remove(split2);
                }
                String treatment = (String)((Map)splitAndValues.getValue()).get("treatment");
                String configurations = ((Map)splitAndValues.getValue()).get("config") != null ? (String)((Map)splitAndValues.getValue()).get("config") : null;
                Object keyOrKeys = ((Map)splitAndValues.getValue()).get("keys");
                split2.configurations.put(treatment, configurations);
                Condition condition = LocalhostSanitizer.createCondition(keyOrKeys, treatment);
                if (condition.conditionType != ConditionType.ROLLOUT) {
                    split2.conditions.add(0, condition);
                } else {
                    split2.conditions.add(condition);
                }
                split2.status = Status.ACTIVE;
                split2.defaultTreatment = treatment;
                split2.trafficTypeName = "user";
                split2.trafficAllocation = 100;
                split2.trafficAllocationSeed = 1;
                splitChange.splits.add(split2);
            }
            splitChange.till = since;
            splitChange.since = since;
            return splitChange;
        }
        catch (FileNotFoundException f) {
            _log.warn(String.format("There was no file named %s found. We created a split client that returns default treatments for all features for all of your users. If you wish to return a specific treatment for a feature, enter the name of that feature name and treatment name separated by whitespace in %s; one pair per line. Empty lines or lines starting with '#' are considered comments", this._splitFile.getPath(), this._splitFile.getPath()), (Throwable)f);
            throw new IllegalStateException("Problem fetching splitChanges: " + f.getMessage(), f);
        }
        catch (Exception e) {
            _log.warn(String.format("Problem to fetch split change using the file %s", this._splitFile.getPath()), (Throwable)e);
            throw new IllegalStateException("Problem fetching splitChanges: " + e.getMessage(), e);
        }
    }
}

