/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.domain;

import java.util.ArrayList;
import java.util.List;

public class PrefixAdapter {
    private static final String DEFAULT_PREFIX = "SPLITIO.";
    private static final String SPLIT_PREFIX = "split.";
    private static final String SPLITS_PREFIX = "splits.";
    private static final String TRAFFIC_TYPE_PREFIX = "trafficType.";
    private static final String EVENTS = "events";
    private static final String IMPRESSIONS = "impressions";
    private static final String SEGMENT = "segment.";
    private static final String COUNT = ".count";
    private static final String UNIQUE_KEYS = "uniquekeys";
    private static final String TILL = "till";
    private static final String TELEMETRY = "telemetry.";
    private static final String LATENCIES = "latencies";
    private static final String EXCEPTIONS = "exceptions";
    private static final String INIT = "init";

    public static String buildSplitKey(String name) {
        return String.format("SPLITIO.split.%s", name);
    }

    public static String buildSplitChangeNumber() {
        return "SPLITIO.splits.till";
    }

    public static String buildGetAllSplit() {
        return "SPLITIO.split.*";
    }

    public static String buildSplitsPrefix() {
        return "SPLITIO.split.";
    }

    public static String buildTrafficTypeExists(String trafficType) {
        return String.format("SPLITIO.trafficType.%s", trafficType);
    }

    public static List<String> buildFetchManySplits(List<String> names) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String name : names) {
            prefixes.add(String.format("SPLITIO.split.%s", name));
        }
        return prefixes;
    }

    public static String buildEvent() {
        return "SPLITIO.events";
    }

    public static String buildImpressions() {
        return "SPLITIO.impressions";
    }

    public static String buildSegment(String segmentName) {
        return String.format("SPLITIO.segment.%s", segmentName);
    }

    public static String buildSegmentAll() {
        return String.format("SPLITIO.segment.*", new Object[0]);
    }

    public static String buildSegmentTill(String segmentName) {
        return String.format("SPLITIO.segment.%s.till", segmentName);
    }

    public static String buildImpressionsCount() {
        return String.format("SPLITIO.impressions.count", new Object[0]);
    }

    public static String buildUniqueKeys() {
        return String.format("SPLITIO.uniquekeys", new Object[0]);
    }

    public static String buildTelemetryLatenciesPrefix() {
        return String.format("SPLITIO.telemetry.latencies", new Object[0]);
    }

    public static String buildTelemetryExceptionsPrefix() {
        return String.format("SPLITIO.telemetry.exceptions", new Object[0]);
    }

    public static String buildTelemetryInit() {
        return String.format("SPLITIO.telemetry.init", new Object[0]);
    }
}

