/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.client.utils.SplitExecutorFactory;
import io.split.engine.common.PushManager;
import io.split.engine.common.SplitAPI;
import io.split.engine.common.Synchronizer;
import io.split.engine.experiments.SplitParser;
import io.split.engine.sse.AuthApiClient;
import io.split.engine.sse.AuthApiClientImp;
import io.split.engine.sse.EventSourceClient;
import io.split.engine.sse.EventSourceClientImp;
import io.split.engine.sse.PushStatusTracker;
import io.split.engine.sse.PushStatusTrackerImp;
import io.split.engine.sse.client.SSEClient;
import io.split.engine.sse.dtos.AuthenticationResponse;
import io.split.engine.sse.dtos.SegmentQueueDto;
import io.split.engine.sse.workers.FeatureFlagWorkerImp;
import io.split.engine.sse.workers.FeatureFlagsWorker;
import io.split.engine.sse.workers.SegmentsWorkerImp;
import io.split.engine.sse.workers.Worker;
import io.split.storages.SplitCacheProducer;
import io.split.telemetry.domain.StreamingEvent;
import io.split.telemetry.domain.enums.StreamEventsEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class PushManagerImp
implements PushManager {
    private static final Logger _log = LoggerFactory.getLogger(PushManager.class);
    private final AuthApiClient _authApiClient;
    private final EventSourceClient _eventSourceClient;
    private final FeatureFlagsWorker _featureFlagsWorker;
    private final Worker<SegmentQueueDto> _segmentWorker;
    private final PushStatusTracker _pushStatusTracker;
    private Future<?> _nextTokenRefreshTask;
    private final ScheduledExecutorService _scheduledExecutorService;
    private AtomicLong _expirationTime;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    @VisibleForTesting
    PushManagerImp(AuthApiClient authApiClient, EventSourceClient eventSourceClient, FeatureFlagsWorker featureFlagsWorker, Worker<SegmentQueueDto> segmentWorker, PushStatusTracker pushStatusTracker, TelemetryRuntimeProducer telemetryRuntimeProducer, ThreadFactory threadFactory) {
        this._authApiClient = Preconditions.checkNotNull(authApiClient);
        this._eventSourceClient = Preconditions.checkNotNull(eventSourceClient);
        this._featureFlagsWorker = featureFlagsWorker;
        this._segmentWorker = segmentWorker;
        this._pushStatusTracker = pushStatusTracker;
        this._expirationTime = new AtomicLong();
        this._scheduledExecutorService = SplitExecutorFactory.buildSingleThreadScheduledExecutor(threadFactory, "Split-SSERefreshToken-%d");
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    public static PushManagerImp build(Synchronizer synchronizer, String streamingUrl, String authUrl, SplitAPI splitAPI, LinkedBlockingQueue<PushManager.Status> statusMessages, TelemetryRuntimeProducer telemetryRuntimeProducer, ThreadFactory threadFactory, SplitParser splitParser, SplitCacheProducer splitCacheProducer) {
        FeatureFlagWorkerImp featureFlagsWorker = new FeatureFlagWorkerImp(synchronizer, splitParser, splitCacheProducer, telemetryRuntimeProducer);
        SegmentsWorkerImp segmentWorker = new SegmentsWorkerImp(synchronizer);
        PushStatusTrackerImp pushStatusTracker = new PushStatusTrackerImp(statusMessages, telemetryRuntimeProducer);
        return new PushManagerImp(new AuthApiClientImp(authUrl, splitAPI.getHttpClient(), telemetryRuntimeProducer), EventSourceClientImp.build(streamingUrl, featureFlagsWorker, segmentWorker, pushStatusTracker, splitAPI.getSseHttpClient(), telemetryRuntimeProducer, threadFactory), featureFlagsWorker, segmentWorker, pushStatusTracker, telemetryRuntimeProducer, threadFactory);
    }

    @Override
    public synchronized void start() {
        AuthenticationResponse response = this._authApiClient.Authenticate();
        _log.debug(String.format("Auth service response pushEnabled: %s", response.isPushEnabled()));
        if (response.isPushEnabled() && this.startSse(response.getToken(), response.getChannels())) {
            this._expirationTime.set(response.getExpiration());
            this._telemetryRuntimeProducer.recordStreamingEvents(new StreamingEvent(StreamEventsEnum.TOKEN_REFRESH.getType(), response.getExpiration(), System.currentTimeMillis()));
            return;
        }
        this.stop();
        if (response.isRetry()) {
            this._pushStatusTracker.handleSseStatus(SSEClient.StatusMessage.RETRYABLE_ERROR);
        } else {
            this._pushStatusTracker.forcePushDisable();
        }
    }

    @Override
    public synchronized void stop() {
        _log.debug("Stopping PushManagerImp");
        this._eventSourceClient.stop();
        this.stopWorkers();
        if (this._nextTokenRefreshTask != null) {
            _log.debug("Cancel nextTokenRefreshTask");
            this._nextTokenRefreshTask.cancel(false);
        }
    }

    @Override
    public synchronized void scheduleConnectionReset() {
        _log.debug(String.format("scheduleNextTokenRefresh in %s SECONDS", this._expirationTime));
        this._nextTokenRefreshTask = this._scheduledExecutorService.schedule(() -> {
            _log.debug("Starting scheduleNextTokenRefresh ...");
            this.stop();
            this.start();
        }, this._expirationTime.get(), TimeUnit.SECONDS);
    }

    private boolean startSse(String token, String channels) {
        try {
            _log.debug("SSE Handler starting ...");
            return this._eventSourceClient.start(channels, token);
        }
        catch (Exception e) {
            _log.debug("Exception in SSE Handler start: " + e.getMessage());
            return false;
        }
    }

    @Override
    public synchronized void startWorkers() {
        this._featureFlagsWorker.start();
        this._segmentWorker.start();
    }

    @Override
    public synchronized void stopWorkers() {
        this._featureFlagsWorker.stop();
        this._segmentWorker.stop();
    }
}

