/*
 * Decompiled with CFR 0.152.
 */
package io.split.telemetry.synchronizer;

import io.split.client.utils.SplitExecutorFactory;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class TelemetrySyncTask {
    private static final Logger _log = LoggerFactory.getLogger(TelemetrySyncTask.class);
    private final ScheduledExecutorService _telemetrySyncScheduledExecutorService;
    private final TelemetrySynchronizer _telemetrySynchronizer;
    private final int _telemetryRefreshRate;

    public TelemetrySyncTask(int telemetryRefreshRate, TelemetrySynchronizer telemetrySynchronizer, ThreadFactory threadFactory) {
        this._telemetrySynchronizer = Preconditions.checkNotNull(telemetrySynchronizer);
        this._telemetryRefreshRate = telemetryRefreshRate;
        this._telemetrySyncScheduledExecutorService = SplitExecutorFactory.buildSingleThreadScheduledExecutor(threadFactory, "Telemetry-sync-%d");
    }

    public void startScheduledTask() {
        this._telemetrySyncScheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                this._telemetrySynchronizer.synchronizeStats();
            }
            catch (Exception e) {
                _log.warn("Error sending telemetry stats.");
            }
        }, this._telemetryRefreshRate, this._telemetryRefreshRate, TimeUnit.SECONDS);
    }

    public void stopScheduledTask() {
        try {
            this._telemetrySynchronizer.finalSynchronization();
        }
        catch (Exception e) {
            _log.warn("Error trying to send telemetry stats.");
        }
        this._telemetrySyncScheduledExecutorService.shutdown();
    }
}

