/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.hc.client5.http.HttpRoute;
import split.org.apache.hc.client5.http.async.AsyncExecRuntime;
import split.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import split.org.apache.hc.client5.http.auth.CredentialsProvider;
import split.org.apache.hc.client5.http.config.RequestConfig;
import split.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import split.org.apache.hc.client5.http.cookie.CookieStore;
import split.org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import split.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import split.org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import split.org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime;
import split.org.apache.hc.client5.http.protocol.HttpClientContext;
import split.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import split.org.apache.hc.core5.annotation.Contract;
import split.org.apache.hc.core5.annotation.Internal;
import split.org.apache.hc.core5.annotation.ThreadingBehavior;
import split.org.apache.hc.core5.http.HttpException;
import split.org.apache.hc.core5.http.HttpHost;
import split.org.apache.hc.core5.http.config.Lookup;
import split.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import split.org.apache.hc.core5.http.nio.HandlerFactory;
import split.org.apache.hc.core5.http2.nio.pool.H2ConnPool;
import split.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalH2AsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalH2AsyncClient.class);
    private final HttpRoutePlanner routePlanner;
    private final H2ConnPool connPool;

    InternalH2AsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, H2ConnPool connPool, HttpRoutePlanner routePlanner, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, defaultConfig, closeables);
        this.connPool = connPool;
        this.routePlanner = routePlanner;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        return new InternalH2AsyncExecRuntime(LOG, this.connPool, pushHandlerFactory);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, clientContext);
        if (route.isTunnelled()) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

