/*
 * Decompiled with CFR 0.152.
 */
package io.split.fastly.client;

import com.google.common.collect.ImmutableMap;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class FastlyApiClient {
    private static final String FASTLY_URL = "https://api.fastly.com";
    private final Map<String, String> _commonHeaders;
    private final AsyncHttpClientConfig _config;
    private final AsyncHttpExecutor _asyncHttpExecutor;
    private final String _serviceId;
    private final String _apiKey;

    public FastlyApiClient(String apiKey, String serviceId) {
        this(apiKey, serviceId, null);
    }

    public FastlyApiClient(String apiKey, String serviceId, AsyncHttpClientConfig config) {
        this._commonHeaders = ImmutableMap.of((Object)"Fastly-Key", (Object)apiKey, (Object)"Accept", (Object)"application/json");
        this._config = config;
        this._apiKey = apiKey;
        this._serviceId = serviceId;
        this._asyncHttpExecutor = new AsyncHttpExecutor();
    }

    public Future<Response> vclUpload(int version, String vcl, String id, String name) {
        String apiUrl = String.format("%s/service/%s/version/%d/vcl", FASTLY_URL, this._serviceId, version);
        return this._asyncHttpExecutor.execute(apiUrl, Method.POST, (Map<String, String>)ImmutableMap.builder().putAll(this._commonHeaders).put((Object)"Content-Type", (Object)"application/x-www-form-urlencoded").build(), (Map<String, String>)ImmutableMap.builder().put((Object)"content", (Object)vcl).put((Object)"name", (Object)name).put((Object)"id", (Object)id).build());
    }

    public List<Future<Response>> vclUpdate(int version, Map<String, String> vcl) {
        List<Future<Response>> responses = vcl.entrySet().stream().map(e -> {
            String apiUrl = String.format("%s/service/%s/version/$d/vcl/%s", FASTLY_URL, this._serviceId, version, e.getKey());
            return this._asyncHttpExecutor.execute(apiUrl, Method.PUT, (Map<String, String>)ImmutableMap.builder().putAll(this._commonHeaders).put((Object)"Content-Type", (Object)"application/x-www-form-urlencoded").build(), (Map<String, String>)ImmutableMap.builder().put((Object)"content", e.getValue()).put((Object)"name", e.getKey()).build());
        }).collect(Collectors.toList());
        return responses;
    }

    public Future<Response> purgeUrl(String url) {
        return this.purgeUrl(url, Collections.EMPTY_MAP);
    }

    public Future<Response> softPurgeUrl(String url) {
        return this.softPurgeUrl(url, Collections.EMPTY_MAP);
    }

    public Future<Response> softPurgeUrl(String url, Map<String, String> extraHeaders) {
        return this.purgeUrl(url, this.buildHeaderForSoftPurge(extraHeaders));
    }

    public Future<Response> purgeUrl(String url, Map<String, String> extraHeaders) {
        return this._asyncHttpExecutor.execute(url, Method.PURGE, (Map<String, String>)ImmutableMap.builder().putAll(this._commonHeaders).putAll(extraHeaders).build(), Collections.EMPTY_MAP);
    }

    public Future<Response> purgeKey(String key, Map<String, String> extraHeaders) {
        String apiUrl = String.format("%s/service/%s/purge/%s", FASTLY_URL, this._serviceId, key);
        return this._asyncHttpExecutor.execute(apiUrl, Method.POST, (Map<String, String>)ImmutableMap.builder().put((Object)"Fastly-Key", (Object)this._apiKey).putAll(extraHeaders).build(), Collections.EMPTY_MAP);
    }

    public Future<Response> purgeKey(String key) {
        return this.purgeKey(key, Collections.EMPTY_MAP);
    }

    public Future<Response> softPurgeKey(String key, Map<String, String> extraHeaders) {
        return this.purgeKey(key, this.buildHeaderForSoftPurge(extraHeaders));
    }

    public Future<Response> softPurgeKey(String key) {
        return this.softPurgeKey(key, Collections.EMPTY_MAP);
    }

    public Future<Response> purgeAll() {
        String apiUrl = String.format("%s/service/%s/purge_all", FASTLY_URL, this._serviceId);
        return this._asyncHttpExecutor.execute(apiUrl, Method.POST, this._commonHeaders, Collections.emptyMap());
    }

    private Map<String, String> buildHeaderForSoftPurge(Map<String, String> extraHeaders) {
        return ImmutableMap.builder().put((Object)"Fastly-Soft-Purge", (Object)"1").putAll(extraHeaders).build();
    }

    public void closeConnectionPool() {
        this._asyncHttpExecutor.close();
    }

    static enum Method {
        POST,
        PURGE,
        PUT,
        GET,
        DELETE;

    }

    private class AsyncHttpExecutor {
        private ExtendedAsyncHttpClient client;
        private AsyncHttpClientConfig defaultConfig = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnections(50).setMaxRequestRetry(3).setMaxConnections(20000).build();

        public AsyncHttpExecutor() {
            this.client = FastlyApiClient.this._config != null ? new ExtendedAsyncHttpClient(FastlyApiClient.this._config) : new ExtendedAsyncHttpClient(this.defaultConfig);
        }

        public void close() {
            this.client.close();
        }

        public Future<Response> execute(String apiUrl, Method method, Map<String, String> headers, Map<String, String> parameters) {
            AsyncHttpClient.BoundRequestBuilder request = this.getRequestForMethod(apiUrl, method);
            this.build(request, headers, parameters);
            return request.execute();
        }

        private AsyncHttpClient.BoundRequestBuilder getRequestForMethod(String apiURL, Method method) {
            if (method == Method.PURGE) {
                return this.client.preparePurge(apiURL);
            }
            if (method == Method.POST) {
                return this.client.preparePost(apiURL);
            }
            if (method == Method.PUT) {
                return this.client.preparePut(apiURL);
            }
            if (method == Method.DELETE) {
                return this.client.prepareDelete(apiURL);
            }
            if (method == Method.GET) {
                return this.client.prepareGet(apiURL);
            }
            return null;
        }

        private void build(AsyncHttpClient.BoundRequestBuilder request, Map<String, String> headers, Map<String, String> parameters) {
            FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap = new FluentCaseInsensitiveStringsMap();
            headers.forEach((k, v) -> fluentCaseInsensitiveStringsMap.add(k, v));
            request.setHeaders(fluentCaseInsensitiveStringsMap);
            FluentStringsMap fluentStringsMap = new FluentStringsMap();
            parameters.forEach((k, v) -> fluentStringsMap.add(k, v));
            if (request.build().getMethod().equals("GET")) {
                request.setQueryParams((Map)fluentStringsMap);
            } else {
                request.setFormParams((Map)fluentStringsMap);
            }
            String host = headers.get("Host");
            if (host != null) {
                request.setVirtualHost(host);
            }
        }
    }

    static class ExtendedAsyncHttpClient
    extends AsyncHttpClient {
        public ExtendedAsyncHttpClient(AsyncHttpClientConfig config) {
            super(config);
        }

        public AsyncHttpClient.BoundRequestBuilder preparePurge(String url) {
            return this.requestBuilder("PURGE", url);
        }
    }
}

