/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.basic;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.util.Await;
import com.twitter.util.Awaitable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogRecordSetBuffer;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.DistributedLogClientBuilder;

public class AtomicWriter {
    private static final String HELP = "AtomicWriter <finagle-name> <stream> <message>[,<message>]";

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println(HELP);
            return;
        }
        String finagleNameStr = args[0];
        String streamName = args[1];
        String[] messages = new String[args.length - 2];
        System.arraycopy(args, 2, messages, 0, messages.length);
        DistributedLogClient client = DistributedLogClientBuilder.newBuilder().clientId(ClientId$.MODULE$.apply("atomic-writer")).name("atomic-writer").thriftmux(true).finagleNameStr(finagleNameStr).build();
        final LogRecordSet.Writer recordSetWriter = LogRecordSet.newWriter((int)16384, (CompressionCodec.Type)CompressionCodec.Type.NONE);
        ArrayList writeFutures = Lists.newArrayListWithExpectedSize((int)messages.length);
        String[] stringArray = messages;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String msg;
            final String message = msg = stringArray[i];
            ByteBuffer msgBuf = ByteBuffer.wrap(msg.getBytes(Charsets.UTF_8));
            CompletableFuture writeFuture = FutureUtils.createFuture();
            writeFuture.whenComplete((BiConsumer)new FutureEventListener<DLSN>(){

                public void onFailure(Throwable cause) {
                    System.out.println("Encountered error on writing data");
                    cause.printStackTrace(System.err);
                    Runtime.getRuntime().exit(0);
                }

                public void onSuccess(DLSN dlsn) {
                    System.out.println("Write '" + message + "' as record " + dlsn);
                }
            });
            recordSetWriter.writeRecord(msgBuf, writeFuture);
            writeFutures.add(writeFuture);
        }
        Await.result((Awaitable)client.writeRecordSet(streamName, (LogRecordSetBuffer)recordSetWriter).addEventListener((com.twitter.util.FutureEventListener)new com.twitter.util.FutureEventListener<DLSN>(){

            public void onFailure(Throwable cause) {
                recordSetWriter.abortTransmit(cause);
                System.out.println("Encountered error on writing data");
                cause.printStackTrace(System.err);
                Runtime.getRuntime().exit(0);
            }

            public void onSuccess(DLSN dlsn) {
                recordSetWriter.completeTransmit(dlsn.getLogSegmentSequenceNo(), dlsn.getEntryId(), dlsn.getSlotId());
            }
        }));
        FutureUtils.result((CompletableFuture)FutureUtils.collect((List)writeFutures));
        client.close();
    }
}

