/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.basic;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.util.FutureEventListener;
import java.nio.ByteBuffer;
import java.util.List;
import jline.ConsoleReader;
import org.apache.commons.lang.StringUtils;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.client.DistributedLogMultiStreamWriter;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.DistributedLogClientBuilder;

public class ConsoleProxyMultiWriter {
    private static final String HELP = "ConsoleProxyWriter <finagle-name> <stream-1>[,<stream-2>,...,<stream-n>]";
    private static final String PROMPT_MESSAGE = "[dlog] > ";

    public static void main(String[] args) throws Exception {
        String line;
        if (2 != args.length) {
            System.out.println(HELP);
            return;
        }
        String finagleNameStr = args[0];
        String streamList = args[1];
        DistributedLogClient client = DistributedLogClientBuilder.newBuilder().clientId(ClientId$.MODULE$.apply("console-proxy-writer")).name("console-proxy-writer").thriftmux(true).finagleNameStr(finagleNameStr).build();
        Object[] streamNameList = StringUtils.split((String)streamList, (char)',');
        DistributedLogMultiStreamWriter multiStreamWriter = DistributedLogMultiStreamWriter.newBuilder().streams((List)Lists.newArrayList((Object[])streamNameList)).bufferSize(0).client(client).flushIntervalMs(0).firstSpeculativeTimeoutMs(10000).maxSpeculativeTimeoutMs(20000).requestTimeoutMs(50000L).build();
        ConsoleReader reader = new ConsoleReader();
        while ((line = reader.readLine(PROMPT_MESSAGE)) != null) {
            multiStreamWriter.write(ByteBuffer.wrap(line.getBytes(Charsets.UTF_8))).addEventListener((FutureEventListener)new FutureEventListener<DLSN>(){

                public void onFailure(Throwable cause) {
                    System.out.println("Encountered error on writing data");
                    cause.printStackTrace(System.err);
                    Runtime.getRuntime().exit(0);
                }

                public void onSuccess(DLSN value) {
                }
            });
        }
        multiStreamWriter.close();
        client.close();
    }
}

