/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.basic;

import com.google.common.base.Charsets;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import jline.ConsoleReader;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;

public class ConsoleWriter {
    private static final String HELP = "ConsoleWriter <uri> <string>";
    private static final String PROMPT_MESSAGE = "[dlog] > ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (2 != args.length) {
            System.out.println(HELP);
            return;
        }
        String dlUriStr = args[0];
        String streamName = args[1];
        URI uri = URI.create(dlUriStr);
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.setImmediateFlushEnabled(true);
        conf.setOutputBufferSize(0);
        conf.setPeriodicFlushFrequencyMilliSeconds(0);
        conf.setLockTimeout(0L);
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).regionId(0).clientId("console-writer").build();
        System.out.println("Opening log stream " + streamName);
        DistributedLogManager dlm = namespace.openLog(streamName);
        try {
            AsyncLogWriter writer = null;
            try {
                String line;
                writer = (AsyncLogWriter)FutureUtils.result((CompletableFuture)dlm.openAsyncLogWriter());
                ConsoleReader reader = new ConsoleReader();
                while ((line = reader.readLine(PROMPT_MESSAGE)) != null) {
                    writer.write(new LogRecord(System.currentTimeMillis(), line.getBytes(Charsets.UTF_8))).whenComplete((BiConsumer)new FutureEventListener<DLSN>(){

                        public void onFailure(Throwable cause) {
                            System.out.println("Encountered error on writing data");
                            cause.printStackTrace(System.err);
                            Runtime.getRuntime().exit(0);
                        }

                        public void onSuccess(DLSN value) {
                        }
                    });
                }
            }
            finally {
                if (null != writer) {
                    FutureUtils.result((CompletableFuture)writer.asyncClose(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
                }
            }
        }
        finally {
            dlm.close();
            namespace.close();
        }
    }
}

