/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.basic;

import com.google.common.base.Charsets;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.exceptions.LogEmptyException;
import org.apache.distributedlog.exceptions.LogNotFoundException;

public class MultiReader {
    private static final String HELP = "TailReader <uri> <stream-1>[,<stream-2>,...,<stream-n>]";

    public static void main(String[] args) throws Exception {
        if (2 != args.length) {
            System.out.println(HELP);
            return;
        }
        String dlUriStr = args[0];
        String streamList = args[1];
        URI uri = URI.create(dlUriStr);
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        String[] streamNameList = StringUtils.split((String)streamList, (char)',');
        DistributedLogManager[] managers = new DistributedLogManager[streamNameList.length];
        for (int i = 0; i < managers.length; ++i) {
            String streamName = streamNameList[i];
            System.out.println("Opening log stream " + streamName);
            managers[i] = namespace.openLog(streamName);
        }
        final CountDownLatch keepAliveLatch = new CountDownLatch(1);
        DistributedLogManager[] distributedLogManagerArray = managers;
        int n = distributedLogManagerArray.length;
        for (int i = 0; i < n; ++i) {
            DistributedLogManager dlm;
            final DistributedLogManager manager = dlm = distributedLogManagerArray[i];
            dlm.getLastLogRecordAsync().whenComplete((BiConsumer)new FutureEventListener<LogRecordWithDLSN>(){

                public void onFailure(Throwable cause) {
                    if (cause instanceof LogNotFoundException) {
                        System.err.println("Log stream " + manager.getStreamName() + " is not found. Please create it first.");
                        keepAliveLatch.countDown();
                    } else if (cause instanceof LogEmptyException) {
                        System.err.println("Log stream " + manager.getStreamName() + " is empty.");
                        MultiReader.readLoop(manager, DLSN.InitialDLSN, keepAliveLatch);
                    } else {
                        System.err.println("Encountered exception on process stream " + manager.getStreamName());
                        keepAliveLatch.countDown();
                    }
                }

                public void onSuccess(LogRecordWithDLSN record) {
                    MultiReader.readLoop(manager, record.getDlsn(), keepAliveLatch);
                }
            });
        }
        keepAliveLatch.await();
        for (DistributedLogManager dlm : managers) {
            dlm.close();
        }
        namespace.close();
    }

    private static void readLoop(final DistributedLogManager dlm, DLSN dlsn, final CountDownLatch keepAliveLatch) {
        System.out.println("Wait for records from " + dlm.getStreamName() + " starting from " + dlsn);
        dlm.openAsyncLogReader(dlsn).whenComplete((BiConsumer)new FutureEventListener<AsyncLogReader>(){

            public void onFailure(Throwable cause) {
                System.err.println("Encountered error on reading records from stream " + dlm.getStreamName());
                cause.printStackTrace(System.err);
                keepAliveLatch.countDown();
            }

            public void onSuccess(AsyncLogReader reader) {
                System.out.println("Open reader to read records from stream " + reader.getStreamName());
                MultiReader.readLoop(reader, keepAliveLatch);
            }
        });
    }

    private static void readLoop(final AsyncLogReader reader, final CountDownLatch keepAliveLatch) {
        FutureEventListener<LogRecordWithDLSN> readListener = new FutureEventListener<LogRecordWithDLSN>(){

            public void onFailure(Throwable cause) {
                System.err.println("Encountered error on reading records from stream " + reader.getStreamName());
                cause.printStackTrace(System.err);
                keepAliveLatch.countDown();
            }

            public void onSuccess(LogRecordWithDLSN record) {
                System.out.println("Received record " + record.getDlsn() + " from stream " + reader.getStreamName());
                System.out.println("\"\"\"");
                System.out.println(new String(record.getPayload(), Charsets.UTF_8));
                System.out.println("\"\"\"");
                reader.readNext().whenComplete((BiConsumer)((Object)this));
            }
        };
        reader.readNext().whenComplete((BiConsumer)readListener);
    }
}

