/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.basic;

import com.google.common.base.Charsets;
import com.google.common.util.concurrent.RateLimiter;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.util.FutureEventListener;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.DistributedLogClientBuilder;

public class RecordGenerator {
    private static final String HELP = "RecordGenerator <finagle-name> <stream> <rate>";

    public static void main(String[] args) throws Exception {
        if (3 != args.length) {
            System.out.println(HELP);
            return;
        }
        String finagleNameStr = args[0];
        String streamName = args[1];
        double rate = Double.parseDouble(args[2]);
        RateLimiter limiter = RateLimiter.create((double)rate);
        DistributedLogClient client = DistributedLogClientBuilder.newBuilder().clientId(ClientId$.MODULE$.apply("record-generator")).name("record-generator").thriftmux(true).finagleNameStr(finagleNameStr).build();
        final CountDownLatch keepAliveLatch = new CountDownLatch(1);
        final AtomicLong numWrites = new AtomicLong(0L);
        final AtomicBoolean running = new AtomicBoolean(true);
        while (running.get()) {
            limiter.acquire();
            String record = "record-" + System.currentTimeMillis();
            client.write(streamName, ByteBuffer.wrap(record.getBytes(Charsets.UTF_8))).addEventListener((FutureEventListener)new FutureEventListener<DLSN>(){

                public void onFailure(Throwable cause) {
                    System.out.println("Encountered error on writing data");
                    cause.printStackTrace(System.err);
                    running.set(false);
                    keepAliveLatch.countDown();
                }

                public void onSuccess(DLSN value) {
                    long numSuccesses = numWrites.incrementAndGet();
                    if (numSuccesses % 100L == 0L) {
                        System.out.println("Write " + numSuccesses + " records.");
                    }
                }
            });
        }
        keepAliveLatch.await();
        client.close();
    }
}

