/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.basic;

import com.google.common.base.Charsets;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;

public class StreamRewinder {
    private static final String HELP = "StreamRewinder <uri> <string> <seconds>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (3 != args.length) {
            System.out.println(HELP);
            return;
        }
        String dlUriStr = args[0];
        String streamName = args[1];
        int rewindSeconds = Integer.parseInt(args[2]);
        URI uri = URI.create(dlUriStr);
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        System.out.println("Opening log stream " + streamName);
        DistributedLogManager dlm = namespace.openLog(streamName);
        try {
            StreamRewinder.readLoop(dlm, rewindSeconds);
        }
        finally {
            dlm.close();
            namespace.close();
        }
    }

    private static void readLoop(final DistributedLogManager dlm, int rewindSeconds) throws Exception {
        final CountDownLatch keepAliveLatch = new CountDownLatch(1);
        long rewindToTxId = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(rewindSeconds, TimeUnit.SECONDS);
        System.out.println("Record records starting from " + rewindToTxId + " which is " + rewindSeconds + " seconds ago");
        final AsyncLogReader reader = (AsyncLogReader)FutureUtils.result((CompletableFuture)dlm.openAsyncLogReader(rewindToTxId));
        final AtomicBoolean caughtup = new AtomicBoolean(false);
        FutureEventListener<LogRecordWithDLSN> readListener = new FutureEventListener<LogRecordWithDLSN>(){

            public void onFailure(Throwable cause) {
                System.err.println("Encountered error on reading records from stream " + dlm.getStreamName());
                cause.printStackTrace(System.err);
                keepAliveLatch.countDown();
            }

            public void onSuccess(LogRecordWithDLSN record) {
                System.out.println("Received record " + record.getDlsn());
                System.out.println("\"\"\"");
                System.out.println(new String(record.getPayload(), Charsets.UTF_8));
                System.out.println("\"\"\"");
                long diffInMilliseconds = System.currentTimeMillis() - record.getTransactionId();
                if (!caughtup.get() && diffInMilliseconds < 2000L) {
                    System.out.println("Reader caught with latest data");
                    caughtup.set(true);
                }
                reader.readNext().whenComplete((BiConsumer)((Object)this));
            }
        };
        reader.readNext().whenComplete((BiConsumer)readListener);
        keepAliveLatch.await();
        FutureUtils.result((CompletableFuture)reader.asyncClose(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }
}

