/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.basic;

import com.google.common.base.Charsets;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.exceptions.LogEmptyException;
import org.apache.distributedlog.exceptions.LogNotFoundException;

public class TailReader {
    private static final String HELP = "TailReader <uri> <string>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (2 != args.length) {
            System.out.println(HELP);
            return;
        }
        String dlUriStr = args[0];
        String streamName = args[1];
        URI uri = URI.create(dlUriStr);
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        System.out.println("Opening log stream " + streamName);
        DistributedLogManager dlm = namespace.openLog(streamName);
        try {
            LogRecordWithDLSN lastRecord = dlm.getLastLogRecord();
            DLSN dlsn = lastRecord.getDlsn();
            TailReader.readLoop(dlm, dlsn);
        }
        catch (LogNotFoundException lnfe) {
            System.err.println("Log stream " + streamName + " is not found. Please create it first.");
            return;
        }
        catch (LogEmptyException lee) {
            System.err.println("Log stream " + streamName + " is empty.");
            DLSN dlsn = DLSN.InitialDLSN;
            TailReader.readLoop(dlm, dlsn);
        }
        finally {
            dlm.close();
            namespace.close();
        }
    }

    private static void readLoop(final DistributedLogManager dlm, DLSN dlsn) throws Exception {
        final CountDownLatch keepAliveLatch = new CountDownLatch(1);
        System.out.println("Wait for records starting from " + dlsn);
        final AsyncLogReader reader = (AsyncLogReader)FutureUtils.result((CompletableFuture)dlm.openAsyncLogReader(dlsn));
        FutureEventListener<LogRecordWithDLSN> readListener = new FutureEventListener<LogRecordWithDLSN>(){

            public void onFailure(Throwable cause) {
                System.err.println("Encountered error on reading records from stream " + dlm.getStreamName());
                cause.printStackTrace(System.err);
                keepAliveLatch.countDown();
            }

            public void onSuccess(LogRecordWithDLSN record) {
                System.out.println("Received record " + record.getDlsn());
                System.out.println("\"\"\"");
                System.out.println(new String(record.getPayload(), Charsets.UTF_8));
                System.out.println("\"\"\"");
                reader.readNext().whenComplete((BiConsumer)((Object)this));
            }
        };
        reader.readNext().whenComplete((BiConsumer)readListener);
        keepAliveLatch.await();
        FutureUtils.result((CompletableFuture)reader.asyncClose(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }
}

