/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.example;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.types.AbstractDataType;

public class BatchSinkExample {
    public static void main(String[] args) {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
        TableEnvironment tableEnv = TableEnvironment.create((EnvironmentSettings)settings);
        Schema sourceTableSchema = Schema.newBuilder().column("Time_", (AbstractDataType)DataTypes.BIGINT()).column("root.sg.d0.s0", (AbstractDataType)DataTypes.FLOAT()).column("root.sg.d1.s0", (AbstractDataType)DataTypes.FLOAT()).column("root.sg.d1.s1", (AbstractDataType)DataTypes.FLOAT()).build();
        TableDescriptor sourceTableDescriptor = TableDescriptor.forConnector((String)"IoTDB").schema(sourceTableSchema).option("sql", "select ** from root.sg.d0,root.sg.d1").build();
        tableEnv.createTemporaryTable("sourceTable", sourceTableDescriptor);
        Table sourceTable = tableEnv.from("sourceTable");
        Schema sinkTableSchema = Schema.newBuilder().column("Time_", (AbstractDataType)DataTypes.BIGINT()).column("root.sg.d2.s0", (AbstractDataType)DataTypes.FLOAT()).column("root.sg.d3.s0", (AbstractDataType)DataTypes.FLOAT()).column("root.sg.d3.s1", (AbstractDataType)DataTypes.FLOAT()).build();
        TableDescriptor sinkTableDescriptor = TableDescriptor.forConnector((String)"IoTDB").schema(sinkTableSchema).build();
        tableEnv.createTemporaryTable("sinkTable", sinkTableDescriptor);
        sourceTable.renameColumns(new Expression[]{(Expression)Expressions.$((String)"root.sg.d0.s0").as("root.sg.d2.s0", new String[0]), (Expression)Expressions.$((String)"root.sg.d1.s0").as("root.sg.d3.s0", new String[0]), (Expression)Expressions.$((String)"root.sg.d1.s1").as("root.sg.d3.s1", new String[0])}).insertInto("sinkTable").execute().print();
    }
}

