/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.example;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.types.AbstractDataType;

public class BoundedScanExample {
    public static void main(String[] args) throws Exception {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        TableEnvironment tableEnv = TableEnvironment.create((EnvironmentSettings)settings);
        Schema iotdbTableSchema = Schema.newBuilder().column("Time_", (AbstractDataType)DataTypes.BIGINT()).column("root.sg.d0.s0", (AbstractDataType)DataTypes.FLOAT()).column("root.sg.d1.s0", (AbstractDataType)DataTypes.FLOAT()).column("root.sg.d2.s1", (AbstractDataType)DataTypes.FLOAT()).build();
        TableDescriptor iotdbDescriptor = TableDescriptor.forConnector((String)"IoTDB").schema(iotdbTableSchema).option("nodeUrls", "127.0.0.1:6667").option("sql", "select ** from root").build();
        tableEnv.createTemporaryTable("iotdbTable", iotdbDescriptor);
        tableEnv.from("iotdbTable").execute().print();
    }
}

