/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.conf.CommonDescriptor;

public class TimestampPrecisionUtils {
    private static final String timestampPrecision;
    private static final ConvertFunction<Long, TimeUnit, Long> convertFunction;

    public static long convertToCurrPrecision(long sourceTime, TimeUnit sourceUnit) {
        return convertFunction.apply(sourceTime, sourceUnit);
    }

    static {
        switch (timestampPrecision = CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ms": {
                convertFunction = TimeUnit.MILLISECONDS::convert;
                break;
            }
            case "ns": {
                convertFunction = TimeUnit.NANOSECONDS::convert;
                break;
            }
            case "us": {
                convertFunction = TimeUnit.MICROSECONDS::convert;
                break;
            }
            default: {
                convertFunction = null;
            }
        }
    }

    @FunctionalInterface
    private static interface ConvertFunction<T1, T2, R> {
        public R apply(T1 var1, T2 var2);
    }
}

