/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.common.Constants;
import org.apache.iotdb.tool.common.ImportTsFileOperation;
import org.apache.thrift.annotation.Nullable;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataTool {
    protected static String host;
    protected static String port;
    protected static String table;
    protected static String endTime;
    protected static String username;
    protected static String password;
    protected static Boolean aligned;
    protected static String database;
    protected static String startTime;
    protected static int threadNum;
    protected static String targetPath;
    protected static long timeout;
    protected static String timeZoneID;
    protected static String timeFormat;
    protected static String exportType;
    protected static String queryCommand;
    public static String fileType;
    public static String failDir;
    protected static String targetDirectory;
    public static String timeColumn;
    protected static int linesPerFile;
    public static String deviceColumn;
    protected static boolean isRemoteLoad;
    protected static Boolean needDataTypePrinted;
    protected static int batchPointSize;
    protected static boolean sqlDialectTree;
    protected static int linesPerFailedFile;
    protected static String successDir;
    protected static String timestampPrecision;
    protected static String failedFileDirectory;
    protected static ImportTsFileOperation failOperation;
    protected static ZoneId zoneId;
    protected static ImportTsFileOperation successOperation;
    protected static String targetFile;
    protected static final LongAdder loadFileFailedNum;
    protected static final LongAdder loadFileSuccessfulNum;
    protected static final LongAdder processingLoadFailedFileSuccessfulNum;
    protected static final LongAdder processingLoadSuccessfulFileSuccessfulNum;
    private static final IoTPrinter ioTPrinter;
    private static final Logger LOGGER;

    protected AbstractDataTool() {
    }

    protected static String checkRequiredArg(String arg, String name, CommandLine commandLine, String defaultValue) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                return defaultValue;
            }
            String msg = String.format("Required values for option '%s' not provided", name);
            LOGGER.info(msg);
            LOGGER.info("Use -help for more information");
            throw new ArgsErrorException(msg);
        }
        return str;
    }

    protected static void parseBasicParams(CommandLine commandLine) throws ArgsErrorException {
        host = AbstractDataTool.checkRequiredArg("h", "host", commandLine, "127.0.0.1");
        port = AbstractDataTool.checkRequiredArg("p", "port", commandLine, "6667");
        username = AbstractDataTool.checkRequiredArg("u", "username", commandLine, "root");
        password = commandLine.getOptionValue("pw", "root");
    }

    protected static void printHelpOptions(String cmdLineHead, String cmdLineSyntax, HelpFormatter hf, Options tsFileOptions, Options csvOptions, Options sqlOptions, boolean printFileType) {
        ioTPrinter.println("-------------------\n" + cmdLineSyntax + "\n" + "-------------------");
        if (StringUtils.isNotBlank((CharSequence)cmdLineHead)) {
            ioTPrinter.println(cmdLineHead);
        }
        String usageName = cmdLineSyntax.replaceAll(" ", "");
        if (ObjectUtils.isNotEmpty((Object)tsFileOptions)) {
            if (printFileType) {
                ioTPrinter.println("\nfile_type: tsfile\n-------------------");
            }
            hf.printHelp(usageName, tsFileOptions, true);
        }
        if (ObjectUtils.isNotEmpty((Object)csvOptions)) {
            if (printFileType) {
                ioTPrinter.println("\nfile_type: csv\n-------------------");
            }
            hf.printHelp(usageName, csvOptions, true);
        }
        if (ObjectUtils.isNotEmpty((Object)sqlOptions)) {
            if (printFileType) {
                ioTPrinter.println("\nfile_type: sql\n-------------------");
            }
            hf.printHelp(usageName, sqlOptions, true);
        }
    }

    protected static boolean checkTimeFormat() {
        for (String format : Constants.TIME_FORMAT) {
            if (!timeFormat.equals(format)) continue;
            return true;
        }
        for (String format : Constants.STRING_TIME_FORMAT) {
            if (!timeFormat.equals(format)) continue;
            return true;
        }
        LOGGER.info("Input time format {} is not supported, please input like yyyy-MM-dd\\ HH:mm:ss.SSS or yyyy-MM-dd'T'HH:mm:ss.SSS%n", (Object)timeFormat);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(Session session, List<String> deviceIds, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        block13: {
            try {
                if (Boolean.FALSE.equals(aligned)) {
                    session.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                } else {
                    session.insertAlignedRecords(deviceIds, times, measurementsList, typesList, valuesList);
                }
            }
            catch (IoTDBConnectionException e) {
                if (retryTime <= 0) break block13;
                try {
                    session.open();
                }
                catch (IoTDBConnectionException ex) {
                    ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
                }
                AbstractDataTool.writeAndEmptyDataSet(session, deviceIds, times, typesList, valuesList, measurementsList, --retryTime);
            }
            catch (StatementExecutionException e) {
                ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
                try {
                    session.close();
                }
                catch (IoTDBConnectionException ioTDBConnectionException) {
                    // empty catch block
                }
                System.exit(1);
            }
            finally {
                deviceIds.clear();
                times.clear();
                typesList.clear();
                valuesList.clear();
                measurementsList.clear();
            }
        }
    }

    protected static void writeFailedLinesFile(List<String> headerNames, String failedFilePath, List<List<Object>> failedRecords) {
        int failedRecordsSize;
        int fileIndex = 0;
        int from = 0;
        int restFailedRecords = failedRecordsSize = failedRecords.size();
        while (from < failedRecordsSize) {
            int step = Math.min(restFailedRecords, linesPerFailedFile);
            AbstractDataTool.writeCsvFile(headerNames, failedRecords.subList(from, from + step), failedFilePath + "_" + fileIndex++);
            from += step;
            restFailedRecords -= step;
        }
    }

    protected static TSDataType typeInfer(String strValue) {
        if (strValue.contains("\"")) {
            return strValue.length() <= 514 ? TSDataType.STRING : TSDataType.TEXT;
        }
        if (AbstractDataTool.isBoolean(strValue)) {
            return Constants.TYPE_INFER_KEY_DICT.get("boolean");
        }
        if (AbstractDataTool.isNumber(strValue)) {
            if (!strValue.contains(".")) {
                if (AbstractDataTool.isConvertFloatPrecisionLack(StringUtils.trim((String)strValue))) {
                    return Constants.TYPE_INFER_KEY_DICT.get("long");
                }
                return Constants.TYPE_INFER_KEY_DICT.get("int");
            }
            return Constants.TYPE_INFER_KEY_DICT.get("float");
        }
        if ("null".equals(strValue) || "null".toUpperCase().equals(strValue)) {
            return null;
        }
        if ("NaN".equals(strValue)) {
            return Constants.TYPE_INFER_KEY_DICT.get("NaN");
        }
        if (AbstractDataTool.isBlob(strValue)) {
            return Constants.TYPE_INFER_KEY_DICT.get("blob");
        }
        if (strValue.length() <= 512) {
            return TSDataType.STRING;
        }
        return TSDataType.TEXT;
    }

    static boolean isNumber(String s) {
        if (s == null || s.equals("NaN")) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isBlob(String s) {
        return s.length() >= 3 && s.startsWith("X'") && s.endsWith("'");
    }

    private static boolean isBoolean(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    private static boolean isConvertFloatPrecisionLack(String s) {
        return Long.parseLong(s) > 0x2000000L;
    }

    protected static Object typeTrans(String value, TSDataType type) {
        try {
            switch (type) {
                case TEXT: 
                case STRING: {
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        return value.substring(1, value.length() - 1);
                    }
                    return value;
                }
                case BOOLEAN: {
                    if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                        return null;
                    }
                    return Boolean.parseBoolean(value);
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case TIMESTAMP: {
                    return Long.parseLong(value);
                }
                case DATE: {
                    return LocalDate.parse(value);
                }
                case BLOB: {
                    return new Binary(AbstractDataTool.parseHexStringToByteArray(value.replaceFirst("0x", "")));
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static byte[] parseHexStringToByteArray(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            int value = Integer.parseInt(hexString.substring(i, i + 2), 16);
            bytes[i / 2] = (byte)value;
        }
        return bytes;
    }

    protected static long parseTimestamp(String str) {
        long timestamp;
        try {
            timestamp = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            timestamp = DateTimeUtils.convertDatetimeStrToLong(str, zoneId, timestampPrecision);
        }
        return timestamp;
    }

    protected static TSDataType getType(String typeStr) {
        try {
            return TSDataType.valueOf((String)typeStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static Tablet.ColumnCategory getColumnCategory(String typeStr) {
        if (StringUtils.isNotBlank((CharSequence)typeStr)) {
            try {
                return Tablet.ColumnCategory.valueOf((String)typeStr);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected static void writeDataAlignedByDevice(Session session, List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        AbstractDataTool.parseHeaders(headerNames, null, headerTypeMap, headerNameMap);
        AtomicReference<Object> deviceName = new AtomicReference<Object>(null);
        HashSet typeQueriedDevice = new HashSet();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            if (deviceName.get() == null) {
                deviceName.set(recordObj.get(1));
            } else if (!Objects.equals(deviceName.get(), recordObj.get(1))) {
                AbstractDataTool.writeAndEmptyDataSet(session, (String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                deviceName.set(recordObj.get(1));
                pointSize.set(0);
            } else if (pointSize.get() >= batchPointSize) {
                AbstractDataTool.writeAndEmptyDataSet(session, (String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            ArrayList<TSDataType> types = new ArrayList<TSDataType>();
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<String> measurements = new ArrayList<String>();
            AtomicReference<Boolean> isFail = new AtomicReference<Boolean>(false);
            for (Map.Entry headerNameEntry : headerNameMap.entrySet()) {
                TSDataType type;
                String headerNameWithoutType = (String)headerNameEntry.getKey();
                String headerName = (String)headerNameEntry.getValue();
                String value = recordObj.get(headerName);
                if ("".equals(value)) continue;
                if (!headerTypeMap.containsKey(headerNameWithoutType)) {
                    boolean hasResult = false;
                    if (!typeQueriedDevice.contains(deviceName.get())) {
                        if (headerTypeMap.isEmpty()) {
                            HashSet<String> devices = new HashSet<String>();
                            devices.add((String)deviceName.get());
                            AbstractDataTool.queryType(session, devices, headerTypeMap, deviceColumn);
                        }
                        typeQueriedDevice.add((String)deviceName.get());
                    }
                    if ((type = AbstractDataTool.typeInfer(value)) != null) {
                        headerTypeMap.put(headerNameWithoutType, type);
                    } else {
                        ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), headerNameWithoutType, value);
                        isFail.set(true);
                    }
                }
                if ((type = (TSDataType)headerTypeMap.get(headerNameWithoutType)) == null) continue;
                Object valueTrans = AbstractDataTool.typeTrans(value, type);
                if (valueTrans == null) {
                    isFail.set(true);
                    ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), headerNameWithoutType, value, type);
                    continue;
                }
                values.add(valueTrans);
                measurements.add(headerNameWithoutType);
                types.add(type);
                pointSize.getAndIncrement();
            }
            if (Boolean.TRUE.equals(isFail.get())) {
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
            }
            if (!measurements.isEmpty()) {
                times.add(AbstractDataTool.parseTimestamp(recordObj.get(timeColumn)));
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
        });
        if (!times.isEmpty()) {
            AbstractDataTool.writeAndEmptyDataSet(session, deviceName.get(), times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            AbstractDataTool.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
        ioTPrinter.println("Import completely!");
    }

    protected static void writeDataAlignedByTime(Session session, List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        HashMap<String, List<String>> deviceAndMeasurementNames = new HashMap<String, List<String>>();
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        AbstractDataTool.parseHeaders(headerNames, deviceAndMeasurementNames, headerTypeMap, headerNameMap);
        Set<String> devices = deviceAndMeasurementNames.keySet();
        if (headerTypeMap.isEmpty()) {
            AbstractDataTool.queryType(session, devices, headerTypeMap, "Time");
        }
        ArrayList<String> deviceIds = new ArrayList<String>();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        AtomicReference<Boolean> hasStarted = new AtomicReference<Boolean>(false);
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            if (Boolean.FALSE.equals(hasStarted.get())) {
                hasStarted.set(true);
            } else if (pointSize.get() >= batchPointSize) {
                AbstractDataTool.writeAndEmptyDataSet(session, deviceIds, (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            boolean isFail = false;
            for (Map.Entry entry : deviceAndMeasurementNames.entrySet()) {
                String deviceId = (String)entry.getKey();
                List measurementNames = (List)entry.getValue();
                ArrayList<TSDataType> types = new ArrayList<TSDataType>();
                ArrayList<Object> values = new ArrayList<Object>();
                ArrayList<String> measurements = new ArrayList<String>();
                for (String measurement : measurementNames) {
                    TSDataType type;
                    String header = deviceId + "." + measurement;
                    String value = recordObj.get((String)headerNameMap.get(header));
                    if ("".equals(value)) continue;
                    if (!headerTypeMap.containsKey(header)) {
                        type = AbstractDataTool.typeInfer(value);
                        if (type != null) {
                            headerTypeMap.put(header, type);
                        } else {
                            ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), header, value);
                            isFail = true;
                        }
                    }
                    if ((type = (TSDataType)headerTypeMap.get(header)) == null) continue;
                    Object valueTrans = AbstractDataTool.typeTrans(value, type);
                    if (valueTrans == null) {
                        isFail = true;
                        ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), header, value, type);
                        continue;
                    }
                    measurements.add(header.replace(deviceId + '.', ""));
                    types.add(type);
                    values.add(valueTrans);
                    pointSize.getAndIncrement();
                }
                if (measurements.isEmpty()) continue;
                times.add(AbstractDataTool.parseTimestamp(recordObj.get(timeColumn)));
                deviceIds.add(deviceId);
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
            if (isFail) {
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
            }
        });
        if (!deviceIds.isEmpty()) {
            AbstractDataTool.writeAndEmptyDataSet(session, deviceIds, times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            AbstractDataTool.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
        if (Boolean.TRUE.equals(hasStarted.get())) {
            ioTPrinter.println("Import completely!");
        } else {
            ioTPrinter.println("No records!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(Session session, String device, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        block13: {
            try {
                if (Boolean.FALSE.equals(aligned)) {
                    session.insertRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
                } else {
                    session.insertAlignedRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
                }
            }
            catch (IoTDBConnectionException e) {
                if (retryTime <= 0) break block13;
                try {
                    session.open();
                }
                catch (IoTDBConnectionException ex) {
                    ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
                }
                AbstractDataTool.writeAndEmptyDataSet(session, device, times, typesList, valuesList, measurementsList, --retryTime);
            }
            catch (StatementExecutionException e) {
                ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
                try {
                    session.close();
                }
                catch (IoTDBConnectionException ioTDBConnectionException) {
                    // empty catch block
                }
                System.exit(1);
            }
            finally {
                times.clear();
                typesList.clear();
                valuesList.clear();
                measurementsList.clear();
            }
        }
    }

    private static void queryType(Session session, Set<String> deviceNames, HashMap<String, TSDataType> headerTypeMap, String alignedType) {
        for (String deviceName : deviceNames) {
            String sql = "show timeseries " + deviceName + ".*";
            try {
                SessionDataSet sessionDataSet = session.executeQueryStatement(sql);
                int tsIndex = sessionDataSet.getColumnNames().indexOf("Timeseries");
                int dtIndex = sessionDataSet.getColumnNames().indexOf("DataType");
                while (sessionDataSet.hasNext()) {
                    RowRecord rowRecord = sessionDataSet.next();
                    List fields = rowRecord.getFields();
                    String timeseries = ((Field)fields.get(tsIndex)).getStringValue();
                    String dataType = ((Field)fields.get(dtIndex)).getStringValue();
                    if (Objects.equals(alignedType, "Time")) {
                        headerTypeMap.put(timeseries, AbstractDataTool.getType(dataType));
                        continue;
                    }
                    if (!Objects.equals(alignedType, deviceColumn)) continue;
                    String[] split = PathUtils.splitPathToDetachedNodes((String)timeseries);
                    String measurement = split[split.length - 1];
                    headerTypeMap.put(measurement, AbstractDataTool.getType(dataType));
                }
            }
            catch (IllegalPathException | IoTDBConnectionException | StatementExecutionException e) {
                ioTPrinter.println("Meet error when query the type of timeseries because " + e.getMessage());
                try {
                    session.close();
                }
                catch (IoTDBConnectionException ioTDBConnectionException) {
                    // empty catch block
                }
                System.exit(1);
            }
        }
    }

    protected static void parseHeaders(List<String> headerNames, @Nullable HashMap<String, List<String>> deviceAndMeasurementNames, HashMap<String, TSDataType> headerTypeMap, HashMap<String, String> headerNameMap) throws IllegalPathException {
        String regex = "(?<=\\()\\S+(?=\\))";
        Pattern pattern = Pattern.compile(regex);
        for (String headerName : headerNames) {
            String headerNameWithoutType;
            if ("Time".equalsIgnoreCase(AbstractDataTool.filterBomHeader(headerName))) {
                timeColumn = headerName;
                continue;
            }
            if ("Device".equalsIgnoreCase(headerName)) {
                deviceColumn = headerName;
                continue;
            }
            Matcher matcher = pattern.matcher(headerName);
            if (matcher.find()) {
                String type = matcher.group();
                headerNameWithoutType = headerName.replace("(" + type + ")", "").replaceAll("\\s+", "");
                headerNameMap.put(headerNameWithoutType, headerName);
                headerTypeMap.put(headerNameWithoutType, AbstractDataTool.getType(type));
            } else {
                headerNameWithoutType = headerName;
                headerNameMap.put(headerName, headerName);
            }
            String[] split = PathUtils.splitPathToDetachedNodes((String)headerNameWithoutType);
            String measurementName = split[split.length - 1];
            String deviceName = StringUtils.join((Object[])Arrays.copyOfRange(split, 0, split.length - 1), (char)'.');
            if (deviceAndMeasurementNames == null) continue;
            deviceAndMeasurementNames.putIfAbsent(deviceName, new ArrayList());
            deviceAndMeasurementNames.get(deviceName).add(measurementName);
        }
    }

    protected static String filterBomHeader(String s) {
        byte[] bom = new byte[]{-17, -69, -65};
        byte[] bytes = Arrays.copyOf(s.getBytes(), 3);
        if (Arrays.equals(bom, bytes)) {
            return s.substring(1);
        }
        return s;
    }

    protected static CSVParser readCsvFile(String path) throws IOException {
        return CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setQuote('`').setEscape('\\').setIgnoreEmptyLines(true).build().parse((Reader)new InputStreamReader(new FileInputStream(path)));
    }

    public static Boolean writeCsvFile(List<String> headerNames, List<List<Object>> records, String filePath) {
        try {
            CSVPrinterWrapper csvPrinterWrapper = new CSVPrinterWrapper(filePath);
            if (headerNames != null) {
                csvPrinterWrapper.printRecord(headerNames);
            }
            for (List<Object> CsvRecord : records) {
                csvPrinterWrapper.printRecord(CsvRecord);
            }
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
            return true;
        }
        catch (IOException e) {
            ioTPrinter.printException(e);
            return false;
        }
    }

    static {
        threadNum = 8;
        timeout = -1L;
        fileType = null;
        failDir = "fail/";
        timeColumn = "Time";
        linesPerFile = 10000;
        deviceColumn = "Device";
        isRemoteLoad = true;
        batchPointSize = 100000;
        sqlDialectTree = true;
        linesPerFailedFile = 10000;
        successDir = "success/";
        timestampPrecision = "ms";
        failedFileDirectory = null;
        zoneId = ZoneId.systemDefault();
        targetFile = "dump";
        loadFileFailedNum = new LongAdder();
        loadFileSuccessfulNum = new LongAdder();
        processingLoadFailedFileSuccessfulNum = new LongAdder();
        processingLoadSuccessfulFileSuccessfulNum = new LongAdder();
        ioTPrinter = new IoTPrinter(System.out);
        LOGGER = LoggerFactory.getLogger(AbstractDataTool.class);
    }

    static class CSVPrinterWrapper {
        private final String filePath;
        private final CSVFormat csvFormat;
        private CSVPrinter csvPrinter;

        public CSVPrinterWrapper(String filePath) {
            this.filePath = filePath;
            this.csvFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setEscape('\\').setQuoteMode(QuoteMode.NONE).build();
        }

        public void printRecord(Iterable<?> values) throws IOException {
            if (this.csvPrinter == null) {
                this.csvPrinter = this.csvFormat.print((Appendable)new PrintWriter(this.filePath));
            }
            this.csvPrinter.printRecord(values);
        }

        public void print(Object value) {
            if (this.csvPrinter == null) {
                try {
                    this.csvPrinter = this.csvFormat.print((Appendable)new PrintWriter(this.filePath));
                }
                catch (IOException e) {
                    ioTPrinter.printException(e);
                    return;
                }
            }
            try {
                this.csvPrinter.print(value);
            }
            catch (IOException e) {
                ioTPrinter.printException(e);
            }
        }

        public void println() throws IOException {
            this.csvPrinter.println();
        }

        public void close() throws IOException {
            if (this.csvPrinter != null) {
                this.csvPrinter.close();
            }
        }

        public void flush() throws IOException {
            if (this.csvPrinter != null) {
                this.csvPrinter.flush();
            }
        }
    }
}

