/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.ITableSessionPool;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.TableSessionPoolBuilder;
import org.apache.iotdb.tool.schema.AbstractExportSchema;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;

public class ExportSchemaTable
extends AbstractExportSchema {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static ITableSessionPool sessionPool;
    private static Map<String, String> tableCommentList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws InterruptedException {
        sessionPool = new TableSessionPoolBuilder().nodeUrls(Collections.singletonList(host + ":" + port)).user(username).password(password).maxSize(threadNum + 1).enableCompression(false).enableRedirection(false).enableAutoFetch(false).database(database).build();
        SessionDataSet sessionDataSet = null;
        try (ITableSession session = sessionPool.getSession();){
            sessionDataSet = session.executeQueryStatement(String.format("select * from information_schema.tables where database = '%s'", database));
            ExportSchemaTable.checkDataBaseAndParseTablesBySelectSchema(sessionDataSet);
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            try {
                sessionDataSet = ExportSchemaTable.session.executeQueryStatement(String.format("show tables details from %s", database));
                ExportSchemaTable.checkDataBaseAndParseTablesByShowSchema(sessionDataSet);
            }
            catch (IoTDBConnectionException | StatementExecutionException e1) {
                ioTPrinter.println("Meet error when insert sql because " + e.getMessage());
                System.exit(1);
            }
        }
        finally {
            if (ObjectUtils.isNotEmpty((Object)sessionDataSet)) {
                try {
                    sessionDataSet.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void checkDataBaseAndParseTablesBySelectSchema(SessionDataSet sessionDataSet) throws StatementExecutionException, IoTDBConnectionException {
        HashSet<String> databases = new HashSet<String>();
        HashMap<String, String> tables = new HashMap<String, String>();
        while (sessionDataSet.hasNext()) {
            RowRecord rowRecord = sessionDataSet.next();
            databases.add(rowRecord.getField(0).getStringValue());
            String comment = rowRecord.getField(4).getStringValue();
            tables.putIfAbsent(rowRecord.getField(1).getStringValue(), comment.equals("null") ? null : comment);
        }
        if (!databases.contains(database)) {
            ioTPrinter.println(String.format("The target database %s does not exist", database));
            System.exit(1);
        }
        if (StringUtils.isNotBlank((CharSequence)table)) {
            if (!tables.containsKey(table)) {
                ioTPrinter.println(String.format("There are no tables or the target table %s does not exist", database));
                System.exit(1);
            }
            tableCommentList.put(table, (String)tables.get(table));
        } else {
            tableCommentList.putAll(tables);
        }
    }

    private static void checkDataBaseAndParseTablesByShowSchema(SessionDataSet sessionDataSet) throws StatementExecutionException, IoTDBConnectionException {
        HashMap<String, String> tables = new HashMap<String, String>();
        while (sessionDataSet.hasNext()) {
            RowRecord rowRecord = sessionDataSet.next();
            String comment = rowRecord.getField(3).getStringValue();
            tables.putIfAbsent(rowRecord.getField(0).getStringValue(), comment.equals("null") ? null : comment);
        }
        if (MapUtils.isNotEmpty(tables)) {
            if (!tables.containsKey(table)) {
                ioTPrinter.println(String.format("There are no tables or the target table %s does not exist", database));
                System.exit(1);
            }
            tableCommentList.put(table, (String)tables.get(table));
        } else {
            tableCommentList.putAll(tables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportSchemaToSqlFile() {
        File file = new File(targetDirectory);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        String fileName = targetDirectory + targetFile + "_" + database + ".sql";
        for (String tableName : tableCommentList.keySet()) {
            String comment = tableCommentList.get(tableName);
            SessionDataSet sessionDataSet = null;
            try {
                ITableSession session = sessionPool.getSession();
                try {
                    sessionDataSet = session.executeQueryStatement(String.format("select * from information_schema.columns where database like '%s' and table_name like '%s'", database, tableName));
                    this.exportSchemaBySelect(sessionDataSet, fileName, tableName, comment);
                }
                finally {
                    if (session == null) continue;
                    session.close();
                }
            }
            catch (IOException | IoTDBConnectionException | StatementExecutionException e) {
                try {
                    sessionDataSet = session.executeQueryStatement(String.format("desc %s.%s details", database, tableName));
                    this.exportSchemaByDesc(sessionDataSet, fileName, tableName, comment);
                }
                catch (IOException | IoTDBConnectionException | StatementExecutionException e1) {
                    ioTPrinter.println("Meet error when get table columns information because " + e.getMessage());
                }
            }
            finally {
                if (!ObjectUtils.isNotEmpty((Object)sessionDataSet)) continue;
                try {
                    sessionDataSet.close();
                }
                catch (IoTDBConnectionException | StatementExecutionException throwable) {}
            }
        }
    }

    private void exportSchemaByDesc(SessionDataSet sessionDataSet, String fileName, String tableName, String tableComment) throws IoTDBConnectionException, StatementExecutionException, IOException {
        String dropSql = "DROP TABLE IF EXISTS " + tableName + ";\n";
        StringBuilder sb = new StringBuilder(dropSql);
        sb.append("CREATE TABLE " + tableName + "(\n");
        try (FileWriter writer = new FileWriter(fileName);){
            boolean hasNext = sessionDataSet.hasNext();
            while (hasNext) {
                RowRecord rowRecord = sessionDataSet.next();
                hasNext = sessionDataSet.hasNext();
                List fields = rowRecord.getFields();
                String columnName = ((Field)fields.get(0)).getStringValue();
                String dataType = ((Field)fields.get(1)).getStringValue();
                String category = ((Field)fields.get(2)).getStringValue();
                String comment = ((Field)fields.get(4)).getStringValue();
                comment = comment.equals("null") ? null : comment;
                sb.append("\t" + columnName + " " + dataType + " " + category);
                if (ObjectUtils.isNotEmpty((Object)comment)) {
                    sb.append(" COMMENT '" + comment + "'");
                }
                if (hasNext) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            sb.append("\n)");
            if (StringUtils.isNotBlank((CharSequence)tableComment)) {
                sb.append(" COMMENT '" + tableComment + "'\n");
            }
            sb.append(";\n");
            writer.write(sb.toString());
            writer.flush();
        }
    }

    private void exportSchemaBySelect(SessionDataSet sessionDataSet, String fileName, String tableName, String tableComment) throws IoTDBConnectionException, StatementExecutionException, IOException {
        String dropSql = "DROP TABLE IF EXISTS " + tableName + ";\n";
        StringBuilder sb = new StringBuilder(dropSql);
        sb.append("CREATE TABLE " + tableName + "(\n");
        try (FileWriter writer = new FileWriter(fileName, true);){
            boolean hasNext = sessionDataSet.hasNext();
            while (hasNext) {
                RowRecord rowRecord = sessionDataSet.next();
                hasNext = sessionDataSet.hasNext();
                List fields = rowRecord.getFields();
                String columnName = ((Field)fields.get(2)).getStringValue();
                String dataType = ((Field)fields.get(3)).getStringValue();
                String category = ((Field)fields.get(4)).getStringValue();
                String comment = ((Field)fields.get(6)).getStringValue();
                comment = comment.equals("null") ? null : comment;
                sb.append("\t" + columnName + " " + dataType + " " + category);
                if (ObjectUtils.isNotEmpty((Object)comment)) {
                    sb.append(" COMMENT '" + comment + "'");
                }
                if (hasNext) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            sb.append(")");
            if (StringUtils.isNotBlank((CharSequence)tableComment)) {
                sb.append(" COMMENT '" + tableComment + "'");
            }
            sb.append(";\n");
            writer.append(sb.toString());
            writer.flush();
        }
    }

    @Override
    protected void exportSchemaToCsvFile(String pathPattern, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        tableCommentList = new HashMap<String, String>();
    }
}

