/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.trigger;

import java.util.Collections;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.TriggerAttributes;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsUpdaterTrigger
implements Trigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsUpdaterTrigger.class);
    private static final String TARGET_DEVICE = "root.__system.statistics";
    private static final String TARGET_SERIES = "total_count";
    private String ip;
    private int port;
    private Session session;
    private AtomicLong cnt = new AtomicLong(0L);
    private Future<?> updateFuture;
    private final ScheduledExecutorService triggerInformationUpdateExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"Stateful-Trigger-Statistics-Updater");
    private static final long UPDATE_INTERVAL = 20000L;

    public void onCreate(TriggerAttributes attributes) throws Exception {
        if (!attributes.hasAttribute("ip")) {
            throw new IllegalArgumentException("ip is required");
        }
        this.ip = attributes.getString("ip");
        if (!attributes.hasAttribute("port")) {
            throw new IllegalArgumentException("port is required");
        }
        this.port = Integer.parseInt(attributes.getString("port"));
    }

    public boolean fire(Tablet tablet) throws Exception {
        this.ensureSession();
        if (tablet.bitMaps == null) {
            this.cnt.addAndGet((long)tablet.rowSize * (long)tablet.getSchemas().size());
            return true;
        }
        for (int column = 0; column < tablet.getSchemas().size(); ++column) {
            BitMap bitMap = tablet.bitMaps[column];
            if (bitMap == null) {
                this.cnt.addAndGet(tablet.rowSize);
                continue;
            }
            for (int row = 0; row < tablet.rowSize; ++row) {
                if (bitMap.isMarked(row)) continue;
                this.cnt.incrementAndGet();
            }
        }
        return true;
    }

    public void restore() throws Exception {
        this.ensureSession();
        try {
            SessionDataSet sessionDataSet = this.session.executeQueryStatement(String.format("select last %s from %s", TARGET_SERIES, TARGET_DEVICE));
            if (sessionDataSet.hasNext()) {
                this.cnt = new AtomicLong(((Field)sessionDataSet.next().getFields().get(0)).getLongV());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when trying to restore stateful trigger", (Throwable)e);
        }
        LOGGER.info("###### restore ##########");
    }

    public void onDrop() throws Exception {
        LOGGER.info("********** onDrop() ***********");
        if (this.session != null) {
            this.session.close();
            this.updateFuture.cancel(true);
        }
    }

    public FailureStrategy getFailureStrategy() {
        return FailureStrategy.OPTIMISTIC;
    }

    private void ensureSession() throws IoTDBConnectionException {
        if (this.session == null) {
            this.session = new Session.Builder().host(this.ip).port(this.port).build();
            this.session.open(false);
            this.updateFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.triggerInformationUpdateExecutor, this::updateTask, (long)20000L, (long)20000L, (TimeUnit)TimeUnit.MILLISECONDS);
            LOGGER.info("Stateful-Trigger-Statistics-Updater is successfully started.");
        }
    }

    private void updateTask() {
        try {
            this.session.insertRecord(TARGET_DEVICE, new Date().getTime(), Collections.singletonList(TARGET_SERIES), Collections.singletonList(TSDataType.INT64), new Object[]{this.cnt.get()});
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred in updateTask", (Throwable)e);
        }
    }
}

