/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.cli;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import edu.uci.ics.hyracks.api.client.HyracksConnection;
import edu.uci.ics.hyracks.api.client.IHyracksClientConnection;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.dataset.IHyracksDataset;
import edu.uci.ics.hyracks.api.dataset.IHyracksDatasetReader;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.job.IGlobalJobDataFactory;
import edu.uci.ics.hyracks.api.job.JobFlag;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import edu.uci.ics.hyracks.client.dataset.HyracksDataset;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.common.controllers.CCConfig;
import edu.uci.ics.hyracks.control.common.controllers.NCConfig;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ResultFrameTupleAccessor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.vxquery.compiler.CompilerControlBlock;
import org.apache.vxquery.compiler.algebricks.VXQueryGlobalDataFactory;
import org.apache.vxquery.compiler.algebricks.prettyprint.VXQueryLogicalExpressionPrettyPrintVisitor;
import org.apache.vxquery.context.DynamicContextImpl;
import org.apache.vxquery.context.RootStaticContextImpl;
import org.apache.vxquery.context.StaticContext;
import org.apache.vxquery.context.StaticContextImpl;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.result.ResultUtils;
import org.apache.vxquery.xmlquery.ast.ModuleNode;
import org.apache.vxquery.xmlquery.query.Module;
import org.apache.vxquery.xmlquery.query.XMLQueryCompiler;
import org.apache.vxquery.xmlquery.query.XQueryCompilationListener;
import org.json.JSONException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class VXQuery {
    private final CmdLineOptions opts;
    private ClusterControllerService cc;
    private NodeControllerService[] ncs;
    private IHyracksClientConnection hcc;
    private IHyracksDataset hds;
    private ResultSetId resultSetId;
    private static List<String> timingMessages;
    private static long sumTiming;
    private static long sumSquaredTiming;
    private static long minTiming;
    private static long maxTiming;

    public VXQuery(CmdLineOptions opts) {
        this.opts = opts;
        timingMessages = new ArrayList<String>();
    }

    public static void main(String[] args) throws Exception {
        Date start = new Date();
        CmdLineOptions opts = new CmdLineOptions();
        CmdLineParser parser = new CmdLineParser((Object)opts);
        try {
            parser.parseArgument(args);
        }
        catch (Exception e) {
            parser.printUsage((OutputStream)System.err);
            return;
        }
        if (opts.arguments.isEmpty()) {
            parser.printUsage((OutputStream)System.err);
            return;
        }
        VXQuery vxq = new VXQuery(opts);
        vxq.execute();
        if (opts.timing) {
            Date end = new Date();
            VXQuery.timingMessage("Execution time: " + (end.getTime() - start.getTime()) + " ms");
            if (opts.repeatExec > opts.timingIgnoreQueries) {
                long mean = sumTiming / (long)(opts.repeatExec - opts.timingIgnoreQueries);
                double sd = Math.sqrt((double)sumSquaredTiming / ((double)opts.repeatExec - new Integer(opts.timingIgnoreQueries).doubleValue()) - (double)(mean * mean));
                VXQuery.timingMessage("Average execution time: " + mean + " ms");
                VXQuery.timingMessage("Standard deviation: " + String.format("%.4f", sd));
                VXQuery.timingMessage("Coefficient of variation: " + String.format("%.4f", sd / (double)mean));
                VXQuery.timingMessage("Minimum execution time: " + minTiming + " ms");
                VXQuery.timingMessage("Maximum execution time: " + maxTiming + " ms");
            }
            System.out.println("Timing Summary:");
            for (String time : timingMessages) {
                System.out.println("  " + time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws Exception {
        System.setProperty("vxquery.buffer_size", Integer.toString(this.opts.bufferSize));
        if (this.opts.clientNetIpAddress != null) {
            this.hcc = new HyracksConnection(this.opts.clientNetIpAddress, this.opts.clientNetPort);
            this.runQueries();
        } else {
            if (!this.opts.compileOnly) {
                this.startLocalHyracks();
            }
            try {
                this.runQueries();
            }
            finally {
                if (!this.opts.compileOnly) {
                    this.stopLocalHyracks();
                }
            }
        }
    }

    private void runQueries() throws IOException, SystemException, Exception {
        Date start = null;
        Date end = null;
        for (String query : this.opts.arguments) {
            String qStr = VXQuery.slurp(query);
            if (this.opts.showQuery) {
                System.err.println(qStr);
            }
            XQueryCompilationListener listener = new XQueryCompilationListener(){

                public void notifyCodegenResult(Module module) {
                    if (VXQuery.this.opts.showRP) {
                        JobSpecification jobSpec = module.getHyracksJobSpecification();
                        try {
                            System.err.println(jobSpec.toJSON().toString(2));
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            System.err.println(jobSpec.toString());
                        }
                    }
                }

                public void notifyTranslationResult(Module module) {
                    if (VXQuery.this.opts.showTET) {
                        System.err.println(this.appendPrettyPlan(new StringBuilder(), module).toString());
                    }
                }

                public void notifyTypecheckResult(Module module) {
                }

                public void notifyOptimizedResult(Module module) {
                    if (VXQuery.this.opts.showOET) {
                        System.err.println(this.appendPrettyPlan(new StringBuilder(), module).toString());
                    }
                }

                public void notifyParseResult(ModuleNode moduleNode) {
                    if (VXQuery.this.opts.showAST) {
                        System.err.println(new XStream((HierarchicalStreamDriver)new DomDriver()).toXML((Object)moduleNode));
                    }
                }

                private StringBuilder appendPrettyPlan(StringBuilder sb, Module module) {
                    try {
                        VXQueryLogicalExpressionPrettyPrintVisitor ev = new VXQueryLogicalExpressionPrettyPrintVisitor(module.getModuleContext());
                        LogicalOperatorPrettyPrintVisitor v = new LogicalOperatorPrettyPrintVisitor((ILogicalExpressionVisitor)ev);
                        PlanPrettyPrinter.printPlan((ILogicalPlan)module.getBody(), (StringBuilder)sb, (LogicalOperatorPrettyPrintVisitor)v, (int)0);
                    }
                    catch (AlgebricksException e) {
                        e.printStackTrace();
                    }
                    return sb;
                }
            };
            start = this.opts.timing ? new Date() : null;
            XMLQueryCompiler compiler = new XMLQueryCompiler(listener, this.getNodeList(), this.opts.frameSize, this.opts.availableProcessors, this.opts.joinHashSize);
            this.resultSetId = this.createResultSetId();
            CompilerControlBlock ccb = new CompilerControlBlock((StaticContext)new StaticContextImpl(RootStaticContextImpl.INSTANCE), this.resultSetId, null);
            compiler.compile(query, (Reader)new StringReader(qStr), ccb, this.opts.optimizationLevel);
            if (this.opts.timing) {
                end = new Date();
                VXQuery.timingMessage("Compile time: " + (end.getTime() - start.getTime()) + " ms");
            }
            if (this.opts.compileOnly) continue;
            Module module = compiler.getModule();
            JobSpecification js = module.getHyracksJobSpecification();
            DynamicContextImpl dCtx = new DynamicContextImpl(module.getModuleContext());
            js.setGlobalJobDataFactory((IGlobalJobDataFactory)new VXQueryGlobalDataFactory(dCtx.createFactory()));
            PrintWriter writer = new PrintWriter(System.out, true);
            for (int i = 0; i < this.opts.repeatExec; ++i) {
                start = this.opts.timing ? new Date() : null;
                this.runJob(js, writer);
                if (!this.opts.timing) continue;
                end = new Date();
                long currentRun = end.getTime() - start.getTime();
                if (i + 1 > this.opts.timingIgnoreQueries) {
                    sumTiming += currentRun;
                    sumSquaredTiming += currentRun * currentRun;
                    if (currentRun < minTiming) {
                        minTiming = currentRun;
                    }
                    if (maxTiming < currentRun) {
                        maxTiming = currentRun;
                    }
                }
                VXQuery.timingMessage("Job (" + (i + 1) + ") execution time: " + currentRun + " ms");
            }
        }
    }

    private String[] getNodeList() throws Exception {
        Map nodeControllerInfos = this.hcc.getNodeControllerInfos();
        String[] nodeList = new String[nodeControllerInfos.size()];
        int index = 0;
        for (String node : nodeControllerInfos.keySet()) {
            nodeList[index++] = node;
        }
        return nodeList;
    }

    private void runJob(JobSpecification spec, PrintWriter writer) throws Exception {
        int nReaders = 1;
        if (this.hds == null) {
            this.hds = new HyracksDataset(this.hcc, spec.getFrameSize(), nReaders);
        }
        JobId jobId = this.hcc.startJob(spec, EnumSet.of(JobFlag.PROFILE_RUNTIME));
        ByteBuffer buffer = ByteBuffer.allocate(spec.getFrameSize());
        IHyracksDatasetReader reader = this.hds.createReader(jobId, this.resultSetId);
        ResultFrameTupleAccessor frameTupleAccessor = new ResultFrameTupleAccessor(spec.getFrameSize());
        buffer.clear();
        while (reader.read(buffer) > 0) {
            buffer.clear();
            writer.print(ResultUtils.getStringFromBuffer((ByteBuffer)buffer, (IFrameTupleAccessor)frameTupleAccessor));
            writer.flush();
        }
        this.hcc.waitForCompletion(jobId);
    }

    protected ResultSetId createResultSetId() {
        return new ResultSetId(System.nanoTime());
    }

    public void startLocalHyracks() throws Exception {
        CCConfig ccConfig = new CCConfig();
        ccConfig.clientNetIpAddress = "127.0.0.1";
        ccConfig.clientNetPort = 39000;
        ccConfig.clusterNetIpAddress = "127.0.0.1";
        ccConfig.clusterNetPort = 39001;
        ccConfig.profileDumpPeriod = 10000;
        this.cc = new ClusterControllerService(ccConfig);
        this.cc.start();
        this.ncs = new NodeControllerService[this.opts.localNodeControllers];
        for (int i = 0; i < this.ncs.length; ++i) {
            NCConfig ncConfig = new NCConfig();
            ncConfig.ccHost = "localhost";
            ncConfig.ccPort = 39001;
            ncConfig.clusterNetIPAddress = "127.0.0.1";
            ncConfig.dataIPAddress = "127.0.0.1";
            ncConfig.datasetIPAddress = "127.0.0.1";
            ncConfig.nodeId = "nc" + (i + 1);
            this.ncs[i] = new NodeControllerService(ncConfig);
            this.ncs[i].start();
        }
        this.hcc = new HyracksConnection(ccConfig.clientNetIpAddress, ccConfig.clientNetPort);
    }

    public void stopLocalHyracks() throws Exception {
        for (int i = 0; i < this.ncs.length; ++i) {
            this.ncs[i].stop();
        }
        this.cc.stop();
    }

    private static String slurp(String query) throws IOException {
        return FileUtils.readFileToString((File)new File(query), (String)"UTF-8");
    }

    private static void timingMessage(String message) {
        System.out.println(message);
        timingMessages.add(message);
    }

    static {
        minTiming = Long.MAX_VALUE;
        maxTiming = Long.MIN_VALUE;
    }

    private static class CmdLineOptions {
        @Option(name="-available-processors", usage="Number of available processors. (default java's available processors)")
        private int availableProcessors = -1;
        @Option(name="-client-net-ip-address", usage="IP Address of the ClusterController")
        private String clientNetIpAddress = null;
        @Option(name="-client-net-port", usage="Port of the ClusterController (default 1098)")
        private int clientNetPort = 1098;
        @Option(name="-local-node-controllers", usage="Number of local node controllers (default 1)")
        private int localNodeControllers = 1;
        @Option(name="-frame-size", usage="Frame size in bytes. (default 65536)")
        private int frameSize = 65536;
        @Option(name="-join-hash-size", usage="Join hash size in bytes.")
        private int joinHashSize = -1;
        @Option(name="-buffer-size", usage="Disk read buffer size in bytes.")
        private int bufferSize = -1;
        @Option(name="-O", usage="Optimization Level. Default: Full Optimization")
        private int optimizationLevel = Integer.MAX_VALUE;
        @Option(name="-showquery", usage="Show query string")
        private boolean showQuery;
        @Option(name="-showast", usage="Show abstract syntax tree")
        private boolean showAST;
        @Option(name="-showtet", usage="Show translated expression tree")
        private boolean showTET;
        @Option(name="-showoet", usage="Show optimized expression tree")
        private boolean showOET;
        @Option(name="-showrp", usage="Show Runtime plan")
        private boolean showRP;
        @Option(name="-compileonly", usage="Compile the query and stop")
        private boolean compileOnly;
        @Option(name="-repeatexec", usage="Number of times to repeat execution")
        private int repeatExec = 1;
        @Option(name="-timing", usage="Produce timing information")
        private boolean timing;
        @Option(name="-timing-ignore-queries", usage="Ignore the first X number of quereies.")
        private int timingIgnoreQueries = 2;
        @Option(name="-x", usage="Bind an external variable")
        private Map<String, String> bindings = new HashMap<String, String>();
        @Argument
        private List<String> arguments = new ArrayList<String>();

        private CmdLineOptions() {
        }
    }
}

