/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.client.HyracksConnection;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.dataset.IHyracksDataset;
import org.apache.hyracks.api.dataset.IHyracksDatasetReader;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.job.IGlobalJobDataFactory;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.client.dataset.HyracksDataset;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.resources.memory.FrameManager;
import org.apache.hyracks.dataflow.common.comm.io.ResultFrameTupleAccessor;
import org.apache.vxquery.compiler.CompilerControlBlock;
import org.apache.vxquery.compiler.algebricks.VXQueryGlobalDataFactory;
import org.apache.vxquery.context.DynamicContextImpl;
import org.apache.vxquery.context.RootStaticContextImpl;
import org.apache.vxquery.context.StaticContext;
import org.apache.vxquery.context.StaticContextImpl;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.result.ResultUtils;
import org.apache.vxquery.xmlquery.query.Module;
import org.apache.vxquery.xmlquery.query.VXQueryCompilationListener;
import org.apache.vxquery.xmlquery.query.XMLQueryCompiler;
import org.apache.vxquery.xmlquery.query.XQueryCompilationListener;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class VXQuery {
    private final CmdLineOptions opts;
    private ClusterControllerService cc;
    private NodeControllerService[] ncs;
    private IHyracksClientConnection hcc;
    private IHyracksDataset hds;
    private ResultSetId resultSetId;
    private static List<String> timingMessages = new ArrayList<String>();
    private static long sumTiming;
    private static long sumSquaredTiming;
    private static long minTiming;
    private static long maxTiming;

    public VXQuery(CmdLineOptions opts) {
        this.opts = opts;
    }

    public static void main(String[] args) throws Exception {
        Date start = new Date();
        CmdLineOptions opts = new CmdLineOptions();
        CmdLineParser parser = new CmdLineParser((Object)opts);
        try {
            parser.parseArgument(args);
        }
        catch (Exception e) {
            parser.printUsage((OutputStream)System.err);
            return;
        }
        if (opts.arguments.isEmpty()) {
            parser.printUsage((OutputStream)System.err);
            return;
        }
        VXQuery vxq = new VXQuery(opts);
        vxq.execute();
        if (opts.timing) {
            Date end = new Date();
            VXQuery.timingMessage("Execution time: " + (end.getTime() - start.getTime()) + " ms");
            if (opts.repeatExec > opts.timingIgnoreQueries) {
                long mean = sumTiming / (long)(opts.repeatExec - opts.timingIgnoreQueries);
                double sd = Math.sqrt((double)sumSquaredTiming / ((double)opts.repeatExec - new Integer(opts.timingIgnoreQueries).doubleValue()) - (double)(mean * mean));
                VXQuery.timingMessage("Average execution time: " + mean + " ms");
                VXQuery.timingMessage("Standard deviation: " + String.format("%.4f", sd));
                VXQuery.timingMessage("Coefficient of variation: " + String.format("%.4f", sd / (double)mean));
                VXQuery.timingMessage("Minimum execution time: " + minTiming + " ms");
                VXQuery.timingMessage("Maximum execution time: " + maxTiming + " ms");
            }
            System.out.println("Timing Summary:");
            for (String time : timingMessages) {
                System.out.println("  " + time);
            }
        }
    }

    private void execute() throws Exception {
        System.setProperty("vxquery.buffer_size", Integer.toString(this.opts.bufferSize));
        if (this.opts.clientNetIpAddress != null) {
            this.hcc = new HyracksConnection(this.opts.clientNetIpAddress, this.opts.clientNetPort);
            this.runQueries();
        } else {
            if (!this.opts.compileOnly) {
                this.startLocalHyracks();
            }
            try {
                this.runQueries();
            }
            finally {
                if (!this.opts.compileOnly) {
                    this.stopLocalHyracks();
                }
            }
        }
    }

    private void runQueries() throws IOException, SystemException, Exception {
        Date start = null;
        Date end = null;
        for (String query : this.opts.arguments) {
            String qStr = VXQuery.slurp(query);
            if (this.opts.showQuery) {
                System.err.println(qStr);
            }
            VXQueryCompilationListener listener = new VXQueryCompilationListener(this.opts.showAST, this.opts.showTET, this.opts.showOET, this.opts.showRP);
            start = this.opts.timing ? new Date() : null;
            Map nodeControllerInfos = null;
            if (this.hcc != null) {
                nodeControllerInfos = this.hcc.getNodeControllerInfos();
            }
            XMLQueryCompiler compiler = new XMLQueryCompiler((XQueryCompilationListener)listener, nodeControllerInfos, this.opts.frameSize, this.opts.availableProcessors, this.opts.joinHashSize, this.opts.maximumDataSize, this.opts.hdfsConf);
            this.resultSetId = this.createResultSetId();
            CompilerControlBlock ccb = new CompilerControlBlock((StaticContext)new StaticContextImpl(RootStaticContextImpl.INSTANCE), this.resultSetId, null);
            compiler.compile(query, (Reader)new StringReader(qStr), ccb, this.opts.optimizationLevel);
            if (this.opts.timing) {
                end = new Date();
                VXQuery.timingMessage("Compile time: " + (end.getTime() - start.getTime()) + " ms");
            }
            if (this.opts.compileOnly) continue;
            Module module = compiler.getModule();
            JobSpecification js = module.getHyracksJobSpecification();
            DynamicContextImpl dCtx = new DynamicContextImpl(module.getModuleContext());
            js.setGlobalJobDataFactory((IGlobalJobDataFactory)new VXQueryGlobalDataFactory(dCtx.createFactory()));
            OutputStream resultStream = System.out;
            if (this.opts.resultFile != null) {
                resultStream = new FileOutputStream(new File(this.opts.resultFile));
            }
            PrintWriter writer = new PrintWriter(resultStream, true);
            for (int i = 0; i < this.opts.repeatExec; ++i) {
                start = this.opts.timing ? new Date() : null;
                this.runJob(js, writer);
                if (!this.opts.timing) continue;
                end = new Date();
                long currentRun = end.getTime() - start.getTime();
                if (i + 1 > this.opts.timingIgnoreQueries) {
                    sumTiming += currentRun;
                    sumSquaredTiming += currentRun * currentRun;
                    if (currentRun < minTiming) {
                        minTiming = currentRun;
                    }
                    if (maxTiming < currentRun) {
                        maxTiming = currentRun;
                    }
                }
                VXQuery.timingMessage("Job (" + (i + 1) + ") execution time: " + currentRun + " ms");
            }
        }
    }

    private void runJob(JobSpecification spec, PrintWriter writer) throws Exception {
        int nReaders = 1;
        if (this.hds == null) {
            this.hds = new HyracksDataset(this.hcc, spec.getFrameSize(), nReaders);
        }
        JobId jobId = this.hcc.startJob(spec, EnumSet.of(JobFlag.PROFILE_RUNTIME));
        FrameManager resultDisplayFrameMgr = new FrameManager(spec.getFrameSize());
        VSizeFrame frame = new VSizeFrame((IHyracksFrameMgrContext)resultDisplayFrameMgr);
        IHyracksDatasetReader reader = this.hds.createReader(jobId, this.resultSetId);
        ResultFrameTupleAccessor frameTupleAccessor = new ResultFrameTupleAccessor();
        while (reader.read((IFrame)frame) > 0) {
            writer.print(ResultUtils.getStringFromBuffer((ByteBuffer)frame.getBuffer(), (IFrameTupleAccessor)frameTupleAccessor));
            writer.flush();
            frame.getBuffer().clear();
        }
        this.hcc.waitForCompletion(jobId);
    }

    protected ResultSetId createResultSetId() {
        return new ResultSetId(System.nanoTime());
    }

    public void startLocalHyracks() throws Exception {
        CCConfig ccConfig = new CCConfig();
        ccConfig.clientNetIpAddress = "127.0.0.1";
        ccConfig.clientNetPort = 39000;
        ccConfig.clusterNetIpAddress = "127.0.0.1";
        ccConfig.clusterNetPort = 39001;
        ccConfig.httpPort = 39002;
        ccConfig.profileDumpPeriod = 10000;
        this.cc = new ClusterControllerService(ccConfig);
        this.cc.start();
        this.ncs = new NodeControllerService[this.opts.localNodeControllers];
        for (int i = 0; i < this.ncs.length; ++i) {
            NCConfig ncConfig = new NCConfig();
            ncConfig.ccHost = "localhost";
            ncConfig.ccPort = 39001;
            ncConfig.clusterNetIPAddress = "127.0.0.1";
            ncConfig.dataIPAddress = "127.0.0.1";
            ncConfig.resultIPAddress = "127.0.0.1";
            ncConfig.nodeId = "nc" + (i + 1);
            ncConfig.ioDevices = Files.createTempDirectory(ncConfig.nodeId, new FileAttribute[0]).toString();
            this.ncs[i] = new NodeControllerService(ncConfig);
            this.ncs[i].start();
        }
        this.hcc = new HyracksConnection(ccConfig.clientNetIpAddress, ccConfig.clientNetPort);
    }

    public void stopLocalHyracks() throws Exception {
        for (int i = 0; i < this.ncs.length; ++i) {
            this.ncs[i].stop();
        }
        this.cc.stop();
    }

    private static String slurp(String query) throws IOException {
        return FileUtils.readFileToString((File)new File(query), (String)"UTF-8");
    }

    private static void timingMessage(String message) {
        System.out.println(message);
        timingMessages.add(message);
    }

    static {
        minTiming = Long.MAX_VALUE;
        maxTiming = Long.MIN_VALUE;
    }

    private static class CmdLineOptions {
        @Option(name="-available-processors", usage="Number of available processors. (default: java's available processors)")
        private int availableProcessors = -1;
        @Option(name="-client-net-ip-address", usage="IP Address of the ClusterController.")
        private String clientNetIpAddress = null;
        @Option(name="-client-net-port", usage="Port of the ClusterController. (default: 1098)")
        private int clientNetPort = 1098;
        @Option(name="-local-node-controllers", usage="Number of local node controllers. (default: 1)")
        private int localNodeControllers = 1;
        @Option(name="-frame-size", usage="Frame size in bytes. (default: 65,536)")
        private int frameSize = 65536;
        @Option(name="-join-hash-size", usage="Join hash size in bytes. (default: 67,108,864)")
        private long joinHashSize = -1L;
        @Option(name="-maximum-data-size", usage="Maximum possible data size in bytes. (default: 150,323,855,000)")
        private long maximumDataSize = -1L;
        @Option(name="-buffer-size", usage="Disk read buffer size in bytes.")
        private int bufferSize = -1;
        @Option(name="-O", usage="Optimization Level. (default: Full Optimization)")
        private int optimizationLevel = Integer.MAX_VALUE;
        @Option(name="-showquery", usage="Show query string.")
        private boolean showQuery;
        @Option(name="-showast", usage="Show abstract syntax tree.")
        private boolean showAST;
        @Option(name="-showtet", usage="Show translated expression tree.")
        private boolean showTET;
        @Option(name="-showoet", usage="Show optimized expression tree.")
        private boolean showOET;
        @Option(name="-showrp", usage="Show Runtime plan.")
        private boolean showRP;
        @Option(name="-compileonly", usage="Compile the query and stop.")
        private boolean compileOnly;
        @Option(name="-repeatexec", usage="Number of times to repeat execution.")
        private int repeatExec = 1;
        @Option(name="-result-file", usage="File path to save the query result.")
        private String resultFile = null;
        @Option(name="-timing", usage="Produce timing information.")
        private boolean timing;
        @Option(name="-timing-ignore-queries", usage="Ignore the first X number of quereies.")
        private int timingIgnoreQueries = 2;
        @Option(name="-x", usage="Bind an external variable")
        private Map<String, String> bindings = new HashMap<String, String>();
        @Option(name="-hdfs-conf", usage="Directory path to Hadoop configuration files")
        private String hdfsConf = null;
        @Argument
        private List<String> arguments = new ArrayList<String>();

        private CmdLineOptions() {
        }
    }
}

