/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.nbio.core.util.PrettyXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BiologicalAssemblyTransformation
implements Cloneable,
Comparable<BiologicalAssemblyTransformation>,
Serializable {
    private static final long serialVersionUID = -6388503076022480391L;
    private String id;
    private String chainId;
    private Matrix4d transformation;

    public BiologicalAssemblyTransformation() {
        this.transformation = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public BiologicalAssemblyTransformation(BiologicalAssemblyTransformation src) {
        this.transformation = new Matrix4d(src.transformation);
        this.id = src.getId();
        this.chainId = src.getChainId();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setTransformationMatrix(Matrix4d transformation) {
        this.transformation = transformation;
    }

    public Matrix4d getTransformationMatrix() {
        return this.transformation;
    }

    public void setRotationMatrix(double[][] m) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.transformation.setElement(i, j, m[i][j]);
            }
        }
    }

    public void setTranslation(double[] t) {
        for (int i = 0; i < 3; ++i) {
            this.transformation.setElement(i, 3, t[i]);
        }
    }

    public void transformPoint(double[] point) {
        Point3d p = new Point3d(point[0], point[1], point[2]);
        this.transformation.transform(p);
        point[0] = p.x;
        point[1] = p.y;
        point[2] = p.z;
    }

    public static BiologicalAssemblyTransformation combine(BiologicalAssemblyTransformation matrix1, BiologicalAssemblyTransformation matrix2) {
        Matrix4d transformation = new Matrix4d(matrix1.transformation);
        transformation.mul(matrix2.transformation);
        BiologicalAssemblyTransformation combined = new BiologicalAssemblyTransformation();
        combined.setTransformationMatrix(transformation);
        return combined;
    }

    public boolean isIdentity() {
        return this.transformation.epsilonEquals(new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0), 1.0E-11);
    }

    public String toXML() throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        PrettyXMLWriter xml = new PrettyXMLWriter(new PrintWriter(writer));
        this.toXML(xml);
        xml.close();
        writer.close();
        sw.close();
        return sw.toString();
    }

    public void toXML(PrettyXMLWriter xml) throws IOException {
        int i;
        xml.openTag("transformation");
        xml.attribute("index", this.id);
        xml.openTag("matrix");
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                xml.attribute("m" + (i + 1) + (j + 1), String.format("%.8f", this.transformation.getElement(i, j)));
            }
        }
        xml.closeTag("matrix");
        xml.openTag("shift");
        for (i = 0; i < 3; ++i) {
            xml.attribute("v" + (i + 1), String.format("%.8f", this.transformation.getElement(i, 3)));
        }
        xml.closeTag("shift");
        xml.closeTag("transformation");
    }

    public static BiologicalAssemblyTransformation fromXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        List<BiologicalAssemblyTransformation> transformations = BiologicalAssemblyTransformation.fromMultiXML(xml);
        if (transformations.size() > 0) {
            return transformations.get(0);
        }
        return null;
    }

    public static List<BiologicalAssemblyTransformation> fromMultiXML(String xml) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<BiologicalAssemblyTransformation> transformations = new ArrayList<BiologicalAssemblyTransformation>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        InputSource inStream = new InputSource();
        inStream.setCharacterStream(new StringReader(xml));
        Document doc = db.parse(inStream);
        doc.getDocumentElement().normalize();
        NodeList listOfTransforms = doc.getElementsByTagName("transformation");
        for (int pos = 0; pos < listOfTransforms.getLength(); ++pos) {
            Node rootElement = listOfTransforms.item(pos);
            BiologicalAssemblyTransformation max = new BiologicalAssemblyTransformation();
            max.id = BiologicalAssemblyTransformation.getAttribute(rootElement, "index");
            max.chainId = BiologicalAssemblyTransformation.getAttribute(rootElement, "chainName");
            NodeList listOfChildren = rootElement.getChildNodes();
            for (int i = 0; i < listOfChildren.getLength(); ++i) {
                Node block = listOfChildren.item(i);
                if ("matrix".equals(block.getNodeName())) {
                    max.setRotationMatrix(BiologicalAssemblyTransformation.getMatrixFromXML(block));
                }
                if (!"shift".equals(block.getNodeName())) continue;
                max.setTranslation(BiologicalAssemblyTransformation.getVectorFromXML(block));
            }
            transformations.add(max);
        }
        return transformations;
    }

    private static double[] getVectorFromXML(Node block) {
        double[] d = new double[3];
        for (int i = 0; i < 3; ++i) {
            d[i] = Float.parseFloat(BiologicalAssemblyTransformation.getAttribute(block, "v" + (i + 1)));
        }
        return d;
    }

    private static double[][] getMatrixFromXML(Node block) {
        double[][] m = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String val = BiologicalAssemblyTransformation.getAttribute(block, "m" + (j + 1) + (i + 1));
                m[j][i] = Double.parseDouble(val);
            }
        }
        return m;
    }

    private static String getAttribute(Node node, String attr) {
        if (!node.hasAttributes()) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (atts == null) {
            return null;
        }
        Node att = atts.getNamedItem(attr);
        if (att == null) {
            return null;
        }
        String value = att.getTextContent();
        return value;
    }

    public String toString() {
        return "BiologicalAssemblyTransformation [id=" + this.id + ", chainId=" + this.chainId + ", rotation=" + BiologicalAssemblyTransformation.rotMatrixToString(this.transformation) + ", translation=" + BiologicalAssemblyTransformation.translVecToString(this.transformation) + "]";
    }

    public static String rotMatrixToString(Matrix4d m) {
        return String.format("(%5.2f %5.2f %5.2f, %5.2f %5.2f %5.2f, %5.2f %5.2f %5.2f)", m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
    }

    public static String translVecToString(Matrix4d m) {
        return String.format("(%5.2f %5.2f %5.2f)", m.m03, m.m13, m.m23);
    }

    @Override
    public int compareTo(BiologicalAssemblyTransformation other) {
        int comp = this.chainId.compareTo(other.chainId);
        return comp == 0 ? this.id.compareTo(other.id) : comp;
    }
}

