/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.xtal;

import java.util.HashMap;
import org.biojava.nbio.structure.xtal.CrystalCell;

public enum BravaisLattice {
    TRICLINIC(1, "TRICLINIC", new CrystalCell(1.0, 1.25, 1.5, 60.0, 70.0, 80.0)),
    MONOCLINIC(2, "MONOCLINIC", new CrystalCell(1.0, 1.25, 1.5, 90.0, 60.0, 90.0)),
    ORTHORHOMBIC(3, "ORTHORHOMBIC", new CrystalCell(1.0, 1.25, 1.5, 90.0, 90.0, 90.0)),
    TETRAGONAL(4, "TETRAGONAL", new CrystalCell(1.0, 1.0, 1.25, 90.0, 90.0, 90.0)),
    TRIGONAL(5, "TRIGONAL", new CrystalCell(1.0, 1.0, 1.25, 90.0, 90.0, 120.0)),
    HEXAGONAL(6, "HEXAGONAL", new CrystalCell(1.0, 1.0, 1.25, 90.0, 90.0, 120.0)),
    CUBIC(7, "CUBIC", new CrystalCell(1.0, 1.0, 1.0, 90.0, 90.0, 90.0));

    private static HashMap<String, BravaisLattice> name2bl;
    private String name;
    private int id;
    private CrystalCell exampleUnitCell;

    private BravaisLattice(int id, String name, CrystalCell exampleUnitCell) {
        this.name = name;
        this.id = id;
        this.exampleUnitCell = exampleUnitCell;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public CrystalCell getExampleUnitCell() {
        return this.exampleUnitCell;
    }

    private static HashMap<String, BravaisLattice> initname2bl() {
        HashMap<String, BravaisLattice> name2bl = new HashMap<String, BravaisLattice>();
        for (BravaisLattice bl : BravaisLattice.values()) {
            name2bl.put(bl.getName(), bl);
        }
        return name2bl;
    }

    public static BravaisLattice getByName(String blName) {
        return name2bl.get(blName);
    }

    static {
        name2bl = BravaisLattice.initname2bl();
    }
}

