package org.codeability.sharing.plugins.api;

/**
 * Represents the configuration of a plugin.
 * It provides the actions a plugin supports.
 * @author Michael Breu
 *
 */
public class SharingPluginConfig {
	
	/**
	 * the actions that a plugin supports. It contains a name, 
	 * a command name, and
	 * an importService URL (not a REST URL, but a callback via Browser redirect)
	 * 
	 * @author Michael Breu
	 *
	 */
	public static class Action {
		
		/**
		 * the id of this action.
		 * An arbitrary String, unique for this plugin.
		 */
		public String actionId;
		/**
		 * the call back for this action (in order to be called back).
		 * When the action is invoked the call back URL is extended by 
		 * <ol>
		 *   <li>the shoppingBasketToken</li>
		 *   <li>the apiBaseURL for a REST based callback as query parameter</li>
		 *   <li>the returnURL a URL that should be redirected to, to get back to the original application, as query parameter</li>
		 * </ol>
		 * e.g. http://localhost:8081/sharingImport/<b>10e1a1b5-74da-43a9-80eb-67a2b9cd0f93</b>?<b>returnURL=http://localhost:8080</b>&amp;<b>apiBaseURL=http://localhost:8080/api</b>
		 */
	    public String actionTransferURL;
	    /**
	     * a descriptive name of the action. 
	     * For presentation to the end user.
	     * E.g. "Export to Artemis"
	     */
	    public String actionName;
	    /**
	     * a boolean expression on the exercise meta data to filter the relevant exercises for this action.
	     * The expression is defined in java expression language (see https://docs.oracle.com/javaee/6/tutorial/doc/gjddd.html).
	     * 
	     * e.g. "metadata.type.externalName=='programming exercise"
	     */
	    public String filterELExpression;
	   
	    /**
	     * 
	     * @param actionName the name of the action
	     * @param actionTransferURL the transfer url, to which the action should forward the browser to
	     * @param actionId the id of the action
	     * @param filterELExpression some filter expression in the EL expression language
	     */
	    
	    
	    public Action(String actionId, String actionTransferURL, String actionName, String filterELExpression) {
			super();
			this.actionId = actionId;
			this.actionName = actionName;
			this.actionTransferURL = actionTransferURL;
			this.filterELExpression = filterELExpression;
		}

	    /**
	     * empty constructor for JSON.
	     */
	    public Action() {
	    	// JSON
	    }

	}
	
	/**
	 * the version of this plugin config.
	 */
	public String version = "0.1";
	
	/**
	 * the name of this plugin.
	 */
	public String pluginName;
	
	/**
	 * the list of actions supported by this plugin.
	 */
	public Action[] actions;

	/**
	 * convenience constructor.
	 * @param pluginName the name of the plugin
	 * @param actions the list of supported actions
	 */
	public SharingPluginConfig(String pluginName, Action[] actions) {
		super();
		this.pluginName = pluginName;
		this.actions = actions;
	}

	/**
	 * JSON constructor.
	 */
    public SharingPluginConfig() {
    	// JSON
    }

}
