package org.codeability.sharing.plugins.api;

import org.codeability.sharing.plugins.api.search.SearchResultDTO;

/**
 * represents a collection of exercise items.
 * It is combined with some basic user information, to identify the user by its email.
 * @author Michael Breu
 *
 */
public class ShoppingBasket {
	
	/**
	 * the user information
	 */
	public UserInfo userInfo;
	/**
	 * the list of selected exercises in the basket.
	 */
	public SearchResultDTO[] exerciseInfo;
	
	/**
	 * token valid until (msecs since 1.1.1970)
	 */
	public long tokenValidUntil;


	/**
	 * just a temporary fix, to make constuctor downward compatible.
	 * Should be fixed in development branch of sharing plattform.
	 * @param userInfo the user info
	 * @param exerciseInfo the exercise infos
	 */
	@Deprecated
	public ShoppingBasket(UserInfo userInfo, SearchResultDTO[] exerciseInfo) {
		super();
		this.userInfo = userInfo;
		this.exerciseInfo = exerciseInfo;
		this.tokenValidUntil  = System.currentTimeMillis() + 60 * 60 * 1000L;
	}

	/**
	 * Constructor of the shopping basket
	 * @param userInfo the user info
	 * @param exerciseInfo the list of exercises
	 * @param tokenValidUntil the validity of the basket
	 */
	public ShoppingBasket(UserInfo userInfo, SearchResultDTO[] exerciseInfo, long tokenValidUntil) {
		super();
		this.userInfo = userInfo;
		this.exerciseInfo = exerciseInfo;
		this.tokenValidUntil  = tokenValidUntil;
	}

    /**
     * empty constructor for JSON.
     */
	public ShoppingBasket() {
		// JSON
	}
	

	/**
	 * infos about the user that invoked this action
	 * @author Michael Breu
	 *
	 */
	public static class UserInfo {
		/**
		 * the email of the user that checked out this shopping basket.
		 */
		public String email;

		/**
		 * convenience constructor.
		 * @param email the email of the user
		 */
		public UserInfo(String email) {
			super();
			this.email = email;
		}

		/**
		 * JSON constructor.
		 */
		public UserInfo() {
			// JSON
		}
	}

}
