package org.codeability.sharing.plugins.api;

/**
 * data to identify or authorize a user.
 * @author Michael Breu
 *
 */
public class UserPrincipal {

	private String name;
	private String gitLabAccessToken;
	
	/**
	 * creates a user principal to be used in context of this api
	 * @param name the user name. Just for information
	 * @param gitLabAccessToken the gitlab access token
	 */
	public UserPrincipal(String name, String gitLabAccessToken) {
		super();
		this.name = name;
		this.gitLabAccessToken = gitLabAccessToken;
	}

    /**
     * empty constructor for JSON.
     */
	public UserPrincipal() {
		// JSON
	}
    /**
	 * @return an informative name of the user
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the oAuth2 access token of the current user. This may be used to load permissions.
	 */
	public String getGitLabAccessToken() {
		return gitLabAccessToken;
	}
	/**
	 * @param gitLabAccessToken the gitLabAccessToken to set
	 */
	public void setGitLabAccessToken(String gitLabAccessToken) {
		this.gitLabAccessToken = gitLabAccessToken;
	}
}
