package org.codeability.sharing.plugins.api.jsonSupport;

import java.time.Instant;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;

public final class UTCInstantSerializer implements Converter<Instant, String> {
    @Override
    public String convert(Instant instant) {
        return instant.toString();
    }
    @Override
    public JavaType getInputType(TypeFactory typeFactory) {
        return typeFactory.constructType(Instant.class);
    }
    @Override
    public JavaType getOutputType(TypeFactory typeFactory) {
        return typeFactory.constructType(String.class);
    }
}