package org.codeability.sharing.plugins.api.search;

import java.io.Serializable;
import java.util.Objects;

public class PersonDTO implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 3651543384681399879L;

	private String name;
    private String affiliation;
    private String email;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAffiliation() {
        return affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return "Person: { name: " + this.name + ", affiliation: " + this.affiliation
                + ", email: " + this.email + " }";
    }

    @Override
    public final int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((affiliation == null) ? 0 : affiliation.hashCode());
        result = prime * result + ((email == null) ? 0 : email.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersonDTO)) {
            return false;
        }
        PersonDTO other = (PersonDTO) obj;
        var truthvalue =
        Objects.equals(this.affiliation, other.affiliation)
                && Objects.equals(this.email, other.email) && Objects.equals(this.name, other.name);
        return truthvalue;
    }
}
