package org.codeability.sharing.plugins.api.search;

import java.util.List;

/**
 * DTO for search queries
 */

public class SearchInputDTO {
    private String fulltextQuery;
    private SearchInputMetadataDTO metadata;
    private List<String> selectedRepository;
    private List<String> selectedUniversity;
    private List<String> selectedFileFormat;

	private SearchOrdering ordering = SearchOrdering.getDefault();

    private int page;
    private int pageSize = 10;

    /**
     * empty constructor for JSON.
     */
    public SearchInputDTO() {
    	// empty for JSON
    }
    
    /**
     * convenience constructor for search input
     * @param fulltextQuery the full text query
     * @param metadata the meta data
     * @param selectedRepository the selected repository
     * @param selectedUniversity the selected university
     * @param selectedFileFormat the selected file format
     * @param page the page
     */
    public SearchInputDTO(String fulltextQuery, SearchInputMetadataDTO metadata,
                          List<String> selectedRepository, List<String> selectedUniversity,
                          List<String> selectedFileFormat, int page) {
        this.fulltextQuery = fulltextQuery;
        this.metadata = metadata;
        this.selectedRepository = selectedRepository;
        this.selectedUniversity = selectedUniversity;
        this.selectedFileFormat = selectedFileFormat;
        this.page = page;
    }

    /**
     * returns the full text query
     * @return the full text query
     */
    public String getFulltextQuery() {
        return fulltextQuery;
    }

    /**
     * sets the full text query
     * @param fulltextQuery the full text query
     */
    public void setFulltextQuery(String fulltextQuery) {
        this.fulltextQuery = fulltextQuery;
    }

    /**
     * returns the meta data
     * @return  the meta data
     */
    public SearchInputMetadataDTO getMetadata() {
        return metadata;
    }

    /**
	 * @param metadata the metadata to set
	 */
	public void setMetadata(SearchInputMetadataDTO metadata) {
		this.metadata = metadata;
	}
	
	/**
	 * returns the selected repository.
	 * @return the selected repository
	 * @deprecated not useful
	 */
	@Deprecated
	public List<String> getSelectedRepository() {
        return selectedRepository;
    }

	/**
	 * sets the selected repository.
	 * @param selectedRepository the selected repository
	 * @deprecated not useful
	 */
	@Deprecated
    public void setSelectedRepository(List<String> selectedRepository) {
        this.selectedRepository = selectedRepository;
    }

	/**
	 * gets the selected university
	 * @return the selected university
	 * @deprecated not used
	 */
	@Deprecated
    public List<String> getSelectedUniversity() {
        return selectedUniversity;
    }

    
	/**
	 * sets the selected university
	 * @param selectedUniversity the selected university
	 * @deprecated not used
	 */
	@Deprecated
    public void setSelectedUniversity(List<String> selectedUniversity) {
        this.selectedUniversity = selectedUniversity;
    }

	/**
	 * 
	 * @return the selected file format
	 * @deprecated not used
	 */
	@Deprecated
    public List<String> getSelectedFileFormat() {
        return selectedFileFormat;
    }

	/**
	 * 
	 * sets the selected file format
	 * @param selectedFileFormat the selected file format
	 * @deprecated not used
	 */
	@Deprecated
    public void setSelectedFileFormat(List<String> selectedFileFormat) {
        this.selectedFileFormat = selectedFileFormat;
    }

	/**
	 * gets the requested page
	 * @return the requested page
	 */
    public int getPage() {
        return page;
    }

    /**
     * sets the requested page
     * @param page the requested page
     */
    public void setPage(int page) {
        this.page = page;
    }

    /**
	 * @return the page size
	 */
	public int getPageSize() {
		return pageSize;
	}
	/**
	 * @param pageSize the page size to set
	 */
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
	
	/**
	 * just a convenience method.
	 * @return true, iff metadata has input.
	 */
    public boolean hasMetadataInput() {
        return this.metadata.hasMetadataInput();
    }

	public SearchOrdering getOrdering() {
		return ordering;
	}

	public void setOrdering(SearchOrdering ordering) {
		this.ordering = ordering;
	}

	@Override
	public String toString() {
		return "SearchInputDTO [fulltextQuery=" + fulltextQuery + ", selectedRepository=" + selectedRepository + ", selectedUniversity="
				+ selectedUniversity + ", selectedFileFormat=" + selectedFileFormat + ", page=" + page + ", metadata: {" + metadata + "}]";
	}


}
