package org.codeability.sharing.plugins.api.search;

import org.codeability.sharing.plugins.api.UserPrincipal;

/** 
 * this class is combining credentials and the search query.
 * @author Michael Breu
 *
 */
public class SearchRequestDTO {
	
	private UserPrincipal userPrincipal;
	private  SearchInputDTO query;
	
	
	/**
	 * comfort constructor with selected initialization values
	 * @param userPrincipal the user principal
	 * @param query the query
	 */
	public SearchRequestDTO(UserPrincipal userPrincipal, SearchInputDTO query) {
		super();
		this.userPrincipal = userPrincipal;
		this.query = query;
	}
	
	/**
	 * trivial constructor for JSON
	 */
	public SearchRequestDTO() {
		// JSON
	}
	/**
	 * @return the search query
	 */
	public SearchInputDTO getQuery() {
		return query;
	}
	/**
	 * @param query the query to set
	 */
	public void setQuery(SearchInputDTO query) {
		this.query = query;
	}

	/**
	 * @return the user principal for which the retrieval should be done
	 */
	public UserPrincipal getUserPrincipal() {
		return userPrincipal;
	}

	/**
	 * @param userPrincipal the userPrincipal to set
	 */
	public void setUserPrincipal(UserPrincipal userPrincipal) {
		this.userPrincipal = userPrincipal;
	}
	
	
}
