package org.codeability.sharing.plugins.api.search;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.codeability.sharing.plugins.api.jsonSupport.NoUTCInstantDeserializer;
import org.codeability.sharing.plugins.api.jsonSupport.UTCInstantSerializer;

@JsonInclude(JsonInclude.Include.ALWAYS)
public class SearchResultDTO {

	private GitProjectDTO project;

	public GitProjectDTO getProject() {
        return project;
    }
    private MetadataFile file;
    private UserProvidedMetadataDTO metadata;
	private SearchStatisticsDTO searchStatistics;

    private String exerciseId;

    private int ranking5;
	private List<PluginActionInfo> supportedActions = new ArrayList<>(2);

	public SearchResultDTO() {
        // default constructor
    }

    /**
     * clone constructor.
     *
     * @param toClone source of clone
     */
    public SearchResultDTO(SearchResultDTO toClone) {
        super();
        this.project = toClone.project;
        this.file = toClone.file;
        this.metadata = toClone.metadata;
    }

	public void setProject(GitProjectDTO project) {
        this.project = project;
    }

	/**
	 * @return the exerciseId
	 */
    public String getExerciseId() {
		return exerciseId;
	}

    public MetadataFile getFile() {
        return file;
    }

    public void setFile(MetadataFile file) {
        this.file = file;
    }

    public UserProvidedMetadataDTO getMetadata() {
        return metadata;
    }

    public void setMetadata(UserProvidedMetadataDTO metadata) {
        this.metadata = metadata;
    }

    @Override
    public String toString() {
        return "SearchResultDTO : { project: " + this.project
            + ", file: " + this.file
            + ", metadata: " + this.metadata
            + " }";
    }

    @Override
	public final int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((exerciseId == null) ? 0 : exerciseId.hashCode());
		result = prime * result + ((file == null) ? 0 : file.hashCode());
		result = prime * result + ((metadata == null) ? 0 : metadata.hashCode());
		result = prime * result + ((project == null) ? 0 : project.hashCode());
		result = prime * result
				+ ((getSearchStatistics() == null)
						? 0
						: getSearchStatistics().hashCode());
		return result;
	}

	@Override
	public final boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof SearchResultDTO))
			return false;
		SearchResultDTO other = (SearchResultDTO) obj;
		if (exerciseId == null) {
			if (other.exerciseId != null)
				return false;
		} else if (!exerciseId.equals(other.exerciseId))
			return false;
		if (file == null) {
			if (other.file != null)
				return false;
		} else if (!file.equals(other.file))
			return false;
		if (metadata == null) {
			if (other.metadata != null)
				return false;
		} else if (!metadata.equals(other.metadata))
			return false;
		if (project == null) {
			if (other.project != null)
				return false;
		} else if (!project.equals(other.project))
			return false;
		if (getSearchStatistics() == null) {
			if (other.getSearchStatistics() != null)
				return false;
		} else if (!getSearchStatistics().equals(other.getSearchStatistics()))
			return false;
		return true;
	}

	@JsonInclude(JsonInclude.Include.ALWAYS)
	public static class PluginActionInfo {
		String plugin;
		String action;
		String commandName;

		/**
		 * information about applicable plugins
		 * @param plugin the name of the plugin, just informative
		 * @param action the name of the action, just informative
		 * @param commandName the name of the command, displayed to the user
		 */
		public PluginActionInfo(String plugin, String action, String commandName) {
			super();
			this.plugin = plugin;
			this.action = action;
			this.commandName = commandName;
		}

		public PluginActionInfo() {
			// JSON
		}
		/**
		 * @return the plugin
		 */
		public String getPlugin() {
			return plugin;
		}
		/**
		 * @param plugin the plugin to set
		 */
		public void setPlugin(String plugin) {
			this.plugin = plugin;
		}
		/**
		 * @return the action
		 */
		public String getAction() {
			return action;
		}
		/**
		 * @param action the action to set
		 */
		public void setAction(String action) {
			this.action = action;
		}
		/**
		 * @return the commandName
		 */
		public String getCommandName() {
			return commandName;
		}
		/**
		 * @param commandName the commandName to set
		 */
		public void setCommandName(String commandName) {
			this.commandName = commandName;
		}


	}

	/**
	 * @param exerciseId the exerciseId to set
	 */
	public void setExerciseId(String exerciseId) {
		this.exerciseId = exerciseId;
	}

	/**
	 * @return the ranking5
	 */
	public int getRanking5() {
		return ranking5;
	}

	/**
	 * @param ranking5 the ranking5 to set
	 */
	public void setRanking5(int ranking5) {
		this.ranking5 = ranking5;
	}

	/**
	 * @return the supportedActions
	 */
	public List<PluginActionInfo> getSupportedActions() {
		return supportedActions;
	}

	/**
	 * @param supportedActions the supportedActions to set
	 */
	public void setSupportedActions(List<PluginActionInfo> supportedActions) {
		this.supportedActions = supportedActions;
	}

	public SearchStatisticsDTO getSearchStatistics() {
		return searchStatistics;
	}

	public void setSearchStatistics(SearchStatisticsDTO searchStatistics) {
		this.searchStatistics = searchStatistics;
	}

	@JsonInclude(JsonInclude.Include.ALWAYS)
	public static class MetadataFile {
        private String filename;
        private String path;
        private String commit_id;
        private String parentId;
        private String[] children;
        @JsonDeserialize(converter = NoUTCInstantDeserializer.class)
        @JsonSerialize(converter = UTCInstantSerializer.class)
        private Instant indexing_date;
		@JsonDeserialize(converter = NoUTCInstantDeserializer.class)
		@JsonSerialize(converter = UTCInstantSerializer.class)
		private Instant last_activity_at;

        public String getFilename() {
            return filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getPath() {
            return path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getCommit_id() {
            return commit_id;
        }

        public void setCommit_id(String commit_id) {
            this.commit_id = commit_id;
        }

        public Instant getIndexing_date() {
            return indexing_date;
        }

        public void setIndexing_date(Instant indexing_date) {
            this.indexing_date = indexing_date;
        }

		/**
		 * @return the parentId
		 */
		public String getParentId() {
			return parentId;
		}

		/**
		 * @param parentId the parentId to set
		 */
		public void setParentId(String parentId) {
			this.parentId = parentId;
		}

		/**
		 * @return the children
		 */
		public String[] getChildren() {
			return children;
		}

		/**
		 * @param children the children to set
		 */
		public void setChildren(String[] children) {
			this.children = children;
		}

		@Override
        public final int hashCode() {
            final int prime = 31;
            int result = this.path.hashCode();
			result = prime * result + ((this.commit_id == null)
					? 0
					: this.commit_id.hashCode());
            return result;
        }

        @Override
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MetadataFile)) {
                return false;
            }
            MetadataFile other = (MetadataFile) obj;
            return Objects.equals(this.path, other.path)
                && Objects.equals(this.commit_id, other.commit_id);
        }

        @Override
        public String toString() {
            return "MetadataFile: { filename: " + this.filename
                + ", path: " + this.path
                + ", commit_id: " + this.commit_id
                + ", indexing_date: " + this.indexing_date
                + " }";
        }

		public Instant getLast_activity_at() {
			return last_activity_at;
		}

		public void setLast_activity_at(Instant last_activity_at) {
			this.last_activity_at = last_activity_at;
		}
    }

}
