package org.codeability.sharing.plugins.api.search;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonValue;

public class SearchResultsDTO {

	public enum GitProjectVisibility {
		PRIVATE("private"), PUBLIC("public"), INTERNAL("internal");
		
		private final String externalName;

		private GitProjectVisibility(String externalName) {
			this.externalName = externalName;
		}

		@JsonValue
		public String getExternalName() {
			return externalName;
		}

	}


	private List<SearchResultDTO> searchResult;

	/**
	 *
	 * @return the list of search results on this page, starting with pageStartIndex
	 */
	public List<SearchResultDTO> getSearchResult() {
		return searchResult;
	}

	public void setSearchResult(List<SearchResultDTO> searchResult) {
		this.searchResult = searchResult;
	}

	long hitCount;

	long pageStartIndex;

	public long getPageStartIndex() {
		return pageStartIndex;
	}

	public SearchResultsDTO(List<SearchResultDTO> searchResult, long hitCount, long pageStartIndex) {
		this.searchResult = searchResult;
		this.hitCount = hitCount;
		this.pageStartIndex = pageStartIndex;
	}

	public SearchResultsDTO() {

	}

	/**
	 * returns the number of all hits.
	 *
	 * @return the hit count
	 */
	public long getHitCount() {
		return hitCount;
	}

	public void setHitCount(long hitCount) {
		this.hitCount = hitCount;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		sb.append("SearchResultsDTO:");
		sb.append(System.lineSeparator());
		sb.append("hit count: ");
		sb.append(this.hitCount);
		sb.append(System.lineSeparator());
		sb.append("page start index: ");
		sb.append(this.pageStartIndex);
		sb.append(System.lineSeparator());
		sb.append("list of SearchResultsDTOs:");
		sb.append(System.lineSeparator());
		for (SearchResultDTO result : this.searchResult) {
			sb.append(result);
			sb.append(System.lineSeparator());
			sb.append(System.lineSeparator());
		}
		return sb.toString();
	}
}
