package org.codeability.sharing.plugins.api.search;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

/**
 * A DTO for the statistics entity.
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
public class SearchStatisticsDTO implements Serializable {

    /**
	 * serialVersionUID
	 */
    private static final long serialVersionUID = 1L;

    private Integer views;

    private Integer downloads;

    Boolean badgeRewarded;

    public Integer getViews() {
        return views;
    }

    public void setViews(Integer views) {
        this.views = views;
    }

    public Integer getDownloads() {
        return downloads;
    }

    public void setDownloads(Integer downloads) {
        this.downloads = downloads;
    }

    public Boolean getBadgeRewarded() {
        return badgeRewarded;
    }

    public void setBadgeRewarded(Boolean badgeRewarded) {
        this.badgeRewarded = badgeRewarded;
    }

    @Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SearchStatisticsDTO other = (SearchStatisticsDTO) obj;
		return Objects.equals(badgeRewarded, other.badgeRewarded)
				&& Objects.equals(downloads, other.downloads)
				&& Objects.equals(views, other.views);
	}

    @Override
	public int hashCode() {
		return Objects.hash(badgeRewarded, downloads, views);
	}

    // prettier-ignore
    @Override
    public String toString() {
        return "StatisticsDTO{" +
                ", views=" + getViews() +
                ", downloads=" + getDownloads() +
				((badgeRewarded != null && badgeRewarded.booleanValue())
						? ", badge"
						: "")
				+
                "}";
    }

}
