package org.codeability.sharing.plugins.api.search;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.ALWAYS)
public class UserProvidedMetadataDTO {

	public static class Validity {
		private Date start;
		private Date end;

		public Date getStart() {
			return start;
		}
		public void setStart(Date start) {
			this.start = start;
		}
		public Date getEnd() {
			return end;
		}
		public void setEnd(Date end) {
			this.end = end;
		}
	}
    public UserProvidedMetadataDTO() {
        // default constructor
    }

    private String[] assesses;
    private String audience;
    private PersonDTO[] contributor;
    private PersonDTO[] creator;
    private String description;
    private String difficulty;
    private String educationalAlignment;
    private String educationalFramework;
    private String[] educationalLevel;
    private String[] educationalUse;
    private String[] format;
    private String identifier;
	private String interactivityType;
    private String[] isBasedOn;
    private String image;
    private String[] keyword;
    private String[] language;
    private String learningResourceType;
    private String license;
    private String metadataVersion;
    private String[] programmingLanguage;
    private PersonDTO[] publisher;
    private String[] requires;
    private String status;
    private String structure;
    private String[] subject;
    private String[] teaches;
    private String timeRequired;
    private String title;
    private String typicalAgeRange;
    private String version;
	private Validity valid;

    @JsonIgnore private String[] collectionContent;

    private PublicVisibility publicVisibility;

    private String repositoryURL;

    public String[] getAssesses() {
        return this.assesses;
    }

    public void setAssesses(final String[] assesses) {
        this.assesses = assesses;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(final String audience) {
        this.audience = audience;
    }

    public PersonDTO[] getContributor() {
        return this.contributor;
    }

    public void setContributor(final PersonDTO[] contributor) {
        this.contributor = contributor;
    }

    public PersonDTO[] getCreator() {
        return this.creator;
    }

    public void setCreator(final PersonDTO[] creator) {
        this.creator = creator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(final String difficulty) {
        this.difficulty = difficulty;
    }

    public String getEducationalAlignment() {
        return this.educationalAlignment;
    }

    public void setEducationalAlignment(final String educationalAlignment) {
        this.educationalAlignment = educationalAlignment;
    }

    public String getEducationalFramework() {
        return this.educationalFramework;
    }

    public void setEducationalFramework(final String educationalFramework) {
        this.educationalFramework = educationalFramework;
    }

    public String[] getEducationalLevel() {
        return this.educationalLevel;
    }

    public void setEducationalLevel(final String[] educationalLevel) {
        this.educationalLevel = educationalLevel;
    }

    public String[] getEducationalUse() {
        return this.educationalUse;
    }

    public void setEducationalUse(final String[] educationalUse) {
        this.educationalUse = educationalUse;
    }

    public String[] getFormat() {
        return this.format;
    }

    public void setFormat(final String[] format) {
        this.format = format;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(final String identifier) {
        this.identifier = identifier;
    }

	public String getInteractivityType() {
        return this.interactivityType;
    }

	public void setInteractivityType(final String interactivityType) {
        this.interactivityType = interactivityType;
    }

    public String[] getIsBasedOn() {
        return this.isBasedOn;
    }

    public void setIsBasedOn(final String[] isBasedOn) {
        this.isBasedOn = isBasedOn;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(final String image) {
        this.image = image;
    }

    public String[] getKeyword() {
        return this.keyword;
    }

    public void setKeyword(final String[] keyword) {
        this.keyword = keyword;
    }

    public String[] getLanguage() {
        return this.language;
    }

    public void setLanguage(final String[] language) {
        this.language = language;
    }

    public String getLearningResourceType() {
        return this.learningResourceType;
    }

    public void setLearningResourceType(final String learningResourceType) {
        this.learningResourceType = learningResourceType;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(final String license) {
        this.license = license;
    }

    public String getMetadataVersion() {
        return this.metadataVersion;
    }

    public void setMetadataVersion(final String metadataVersion) {
        this.metadataVersion = metadataVersion;
    }

    public String[] getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    public void setProgrammingLanguage(final String[] programmingLanguage) {
        this.programmingLanguage = programmingLanguage;
    }

    public PersonDTO[] getPublisher() {
        return this.publisher;
    }

    public void setPublisher(final PersonDTO[] publisher) {
        this.publisher = publisher;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public void setRequires(final String[] requires) {
        this.requires = requires;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(final String status) {
        this.status = status;
    }

    public String getStructure() {
        return this.structure;
    }

    public void setStructure(final String structure) {
        this.structure = structure;
    }

    public String[] getSubject() {
        return this.subject;
    }

    public void setSubject(final String[] subject) {
        this.subject = subject;
    }

    public String[] getTeaches() {
        return this.teaches;
    }

    public void setTeaches(final String[] teaches) {
        this.teaches = teaches;
    }

    public String getTimeRequired() {
        return this.timeRequired;
    }

    public void setTimeRequired(final String timeRequired) {
        this.timeRequired = timeRequired;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public String getTypicalAgeRange() {
        return this.typicalAgeRange;
    }

    public void setTypicalAgeRange(final String typicalAgeRange) {
        this.typicalAgeRange = typicalAgeRange;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(final String version) {
        this.version = version;
    }

    public String[] getCollectionContent() {
        return this.collectionContent;
    }

    public void setCollectionContent(final String[] collectionContent) {
        this.collectionContent = collectionContent;
    }

    public PublicVisibility getPublicVisibility() {
        return this.publicVisibility;
    }

    public void setPublicVisibility(final PublicVisibility publicVisibility) {
        this.publicVisibility = publicVisibility;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public void setRepositoryURL(final String repositoryURL) {
        this.repositoryURL = repositoryURL;
    }

    /**
     * clone constructor
     *
     * @param toClone the original
     */
    public UserProvidedMetadataDTO(UserProvidedMetadataDTO toClone) {
        super();
        this.assesses = toClone.assesses;
        this.audience = toClone.audience;
        this.collectionContent = toClone.collectionContent;
        this.contributor = toClone.contributor;
        this.creator = toClone.creator;
        this.description = toClone.description;
        this.difficulty = toClone.difficulty;
        this.educationalAlignment = toClone.educationalAlignment;
        this.educationalFramework = toClone.educationalFramework;
        this.educationalLevel = toClone.educationalLevel;
        this.educationalUse = toClone.educationalUse;
        this.format = toClone.format;
        this.identifier = toClone.identifier;
        this.image = toClone.image;
        this.interactivityType = toClone.interactivityType;
        this.isBasedOn = toClone.isBasedOn;
        this.keyword = toClone.keyword;
        this.language = toClone.language;
        this.learningResourceType = toClone.learningResourceType;
        this.license = toClone.license;
        this.metadataVersion = toClone.metadataVersion;
        this.programmingLanguage = toClone.programmingLanguage;
        this.publisher = toClone.publisher;
        this.requires = toClone.requires;
        this.status = toClone.status;
        this.structure = toClone.structure;
        this.subject = toClone.subject;
        this.teaches = toClone.teaches;
        this.timeRequired = toClone.timeRequired;
        this.title = toClone.title;
        this.typicalAgeRange = toClone.typicalAgeRange;
        this.version = toClone.version;

        this.repositoryURL = toClone.repositoryURL;
    }

    @Override
    public String toString() {
        return "UserProvidedMetadataDTO { "
                + "assesses: " + Arrays.toString(assesses)
                + ", audience: " + audience
                + ", collectionContent: " + Arrays.toString(collectionContent)
                + ", contributor: " + Arrays.toString(contributor)
                + ", creator: " + Arrays.toString(creator)
                + ", description: " + description
                + ", difficulty: " + difficulty
                + ", educationalAlignment: " + educationalAlignment
                + ", educationalFramework: " + educationalFramework
                + ", educationalLevel: " + Arrays.toString(educationalLevel)
                + ", educationalUse: " + Arrays.toString(educationalUse)
                + ", format: " + Arrays.toString(format)
                + ", identifier: " + identifier
                + ", image: " + image
                + ", interactivityType: " + interactivityType
                + ", isBasedOn: " + Arrays.toString(isBasedOn)
                + ", keyword: " + Arrays.toString(keyword)
                + ", language: " + Arrays.toString(language)
                + ", learningResourceType: " + learningResourceType
                + ", license: " + license
                + ", metadataVersion: " + metadataVersion
                + ", programmingLanguage: " + Arrays.toString(programmingLanguage)
                + ", publisher: " + Arrays.toString(publisher)
                + ", requires: " + Arrays.toString(requires)
                + ", status: " + status
                + ", structure: " + structure
                + ", subject: " + Arrays.toString(subject)
                + ", teaches: " + Arrays.toString(teaches)
                + ", timeRequired: " + timeRequired
                + ", title: " + title
                + ", typicalAgeRange: " + typicalAgeRange
                + ", version: " + version + " }"
                + ", repositoryURL: " + repositoryURL;
    }

    @Override
    public final int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(assesses);
        result = prime * result + ((audience == null) ? 0 : audience.hashCode());
        result = prime * result + Arrays.hashCode(collectionContent);
        result = prime * result + Arrays.hashCode(contributor);
        result = prime * result + Arrays.hashCode(creator);
        result = prime * result + ((description == null) ? 0 : description.hashCode());
        result = prime * result + ((difficulty == null) ? 0 : difficulty.hashCode());
        result = prime * result + ((educationalAlignment == null) ? 0 : educationalAlignment.hashCode());
        result = prime * result + ((educationalFramework == null) ? 0 : educationalFramework.hashCode());
        result = prime * result + Arrays.hashCode(educationalLevel);
        result = prime * result + Arrays.hashCode(educationalUse);
        result = prime * result + ((format == null) ? 0 : Arrays.hashCode(format));
        result = prime * result + ((identifier == null) ? 0 : identifier.hashCode());
        result = prime * result + ((image == null) ? 0 : image.hashCode());
        result = prime * result + ((interactivityType == null) ? 0 : interactivityType.hashCode());
        result = prime * result + Arrays.hashCode(isBasedOn);
        result = prime * result + Arrays.hashCode(keyword);
        result = prime * result + Arrays.hashCode(language);
        result = prime * result + ((learningResourceType == null) ? 0 : learningResourceType.hashCode());
        result = prime * result + ((license == null) ? 0 : license.hashCode());
        result = prime * result + ((metadataVersion == null) ? 0 : metadataVersion.hashCode());
        result = prime * result + Arrays.hashCode(programmingLanguage);
        result = prime * result + Arrays.hashCode(publisher);
        result = prime * result + Arrays.hashCode(requires);
		result = prime * result + ((valid == null) ? 0 : valid.hashCode());
        result = prime * result + ((status == null) ? 0 : status.hashCode());
        result = prime * result + ((structure == null) ? 0 : structure.hashCode());
        result = prime * result + Arrays.hashCode(subject);
        result = prime * result + Arrays.hashCode(teaches);
        result = prime * result + ((timeRequired == null) ? 0 : timeRequired.hashCode());
        result = prime * result + ((title == null) ? 0 : title.hashCode());
        result = prime * result + ((typicalAgeRange == null) ? 0 : typicalAgeRange.hashCode());
        result = prime * result + ((version == null) ? 0 : version.hashCode());

        result = prime * result + ((repositoryURL == null) ? 0 : repositoryURL.hashCode());

        result = prime * result + ((publicVisibility == null) ? 0 : publicVisibility.hashCode());
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserProvidedMetadataDTO)) {
            return false;
        }
        UserProvidedMetadataDTO other = (UserProvidedMetadataDTO) obj;
        return Arrays.equals(this.assesses, other.assesses)
                && Objects.equals(this.audience, other.audience)
                && Arrays.equals(this.collectionContent, other.collectionContent)
                && Arrays.equals(this.contributor, other.contributor)
                && Arrays.equals(this.creator, other.creator)
                && Objects.equals(this.description, other.description)
                && Objects.equals(this.difficulty, other.difficulty)
                && Objects.equals(this.educationalAlignment, other.educationalAlignment)
                && Objects.equals(this.educationalFramework, other.educationalFramework)
                && Arrays.equals(this.educationalLevel, other.educationalLevel)
                && Arrays.equals(this.educationalUse, other.educationalUse)
                && Arrays.equals(this.format, other.format)
                && Objects.equals(this.identifier, other.identifier)
				&& Objects.equals(this.valid, other.valid)
                && Objects.equals(this.image, other.image)
				&& Objects.equals(this.interactivityType,
						other.interactivityType)
                && Arrays.equals(this.isBasedOn, other.isBasedOn)
                && Arrays.equals(this.keyword, other.keyword)
                && Arrays.equals(this.language, other.language)
                && Objects.equals(this.learningResourceType, other.learningResourceType)
                && Objects.equals(this.license, other.license)
                && Objects.equals(this.metadataVersion, other.metadataVersion)
                && Arrays.equals(this.programmingLanguage, other.programmingLanguage)
                && Arrays.equals(this.publisher, other.publisher)
                && Arrays.equals(this.requires, other.requires)
                && Objects.equals(this.status, other.status)
                && Objects.equals(this.structure, other.structure)
                && Arrays.equals(this.subject, other.subject)
                && Arrays.equals(this.teaches, other.teaches)
                && Objects.equals(this.timeRequired, other.timeRequired)
                && Objects.equals(this.title, other.title)
                && Objects.equals(this.typicalAgeRange, other.typicalAgeRange)
                && Objects.equals(this.version, other.version)

                && Objects.equals(this.repositoryURL, other.repositoryURL)

                && Objects.equals(this.publicVisibility, other.publicVisibility);
    }


    public Validity getValid() {
		return valid;
	}

	public void setValid(Validity valid) {
		this.valid = valid;
	}


	public static class PublicVisibility {
        private String[] except;

        /**
         * @return the except
         */
        public String[] getExcept() {
            return except;
        }

        /**
         * @param except the except to set
         */
        public void setExcept(String[] except) {
            this.except = except;
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Arrays.deepHashCode(except);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (getClass() != obj.getClass())
                return false;
            PublicVisibility other = (PublicVisibility) obj;
            return Arrays.equals(except, other.except);
        }
    }

    /**
	 * @deprecated currently a free text
	 * @author Micha
	 *
	 */
	@Deprecated
	public enum InteractivityTypeXXX {
        ACTIVE("active"),
        EXPOSITIVE("expositive"),
        MIXED("mixed"),
        @JsonEnumDefaultValue UNSPECIFIED("unspecified");

		InteractivityTypeXXX(final String externalName) {
            this.externalName = externalName;
        }

        private final String externalName;

        @JsonValue
        public String getExternalName() {
            return this.externalName;
        }}
}

