/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1610", priority=Priority.MAJOR, tags={"java8"})
public class AbstractClassNoFieldShouldBeInterfaceCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1610";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1610");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (this.classIsAbstract(tree) && this.classHasNoField(tree)) {
            this.context.addIssue((Tree)tree, RULE, "Convert the abstract class \"" + tree.simpleName().name() + "\" into an interface");
        }
        super.visitClass(tree);
    }

    private boolean classIsAbstract(ClassTree tree) {
        return tree.modifiers().modifiers().contains(Modifier.ABSTRACT);
    }

    private boolean classHasNoField(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (!member.is(Tree.Kind.VARIABLE)) continue;
            return false;
        }
        return true;
    }
}

