/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S1125", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class BooleanLiteralCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1125";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1125");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        String literal = BooleanLiteralCheck.getBooleanLiteralOperands(tree);
        if (BooleanLiteralCheck.hasCorrectOperator((Tree)tree) && literal != null) {
            this.addIssue((Tree)tree, literal);
        }
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        super.visitUnaryExpression(tree);
        String literal = BooleanLiteralCheck.getBooleanLiteral((Tree)tree.expression());
        if (BooleanLiteralCheck.hasCorrectOperator((Tree)tree) && literal != null) {
            this.addIssue((Tree)tree, literal);
        }
    }

    private void addIssue(Tree tree, String literal) {
        this.context.addIssue(tree, RULE, "Remove the literal \"" + literal + "\" boolean value.");
    }

    private static String getBooleanLiteralOperands(BinaryExpressionTree tree) {
        String result = BooleanLiteralCheck.getBooleanLiteral((Tree)tree.leftOperand());
        if (result == null) {
            result = BooleanLiteralCheck.getBooleanLiteral((Tree)tree.rightOperand());
        }
        return result;
    }

    private static String getBooleanLiteral(Tree tree) {
        String result = null;
        if (tree.is(Tree.Kind.BOOLEAN_LITERAL)) {
            result = ((LiteralTree)tree).value();
        }
        return result;
    }

    private static boolean hasCorrectOperator(Tree tree) {
        return tree.is(Tree.Kind.EQUAL_TO) || tree.is(Tree.Kind.NOT_EQUAL_TO) || tree.is(Tree.Kind.CONDITIONAL_AND) || tree.is(Tree.Kind.CONDITIONAL_OR) || tree.is(Tree.Kind.LOGICAL_COMPLEMENT);
    }
}

