/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1155", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CollectionIsEmptyCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1155";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1155");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        if (CollectionIsEmptyCheck.hasCallToSizeMethod(tree) && CollectionIsEmptyCheck.isEmptyComparison(tree)) {
            this.context.addIssue((Tree)tree, RULE, "Use isEmpty() to check whether the collection is empty or not.");
        }
    }

    private static boolean hasCallToSizeMethod(BinaryExpressionTree tree) {
        return CollectionIsEmptyCheck.isCallToSizeMethod(tree.leftOperand()) || CollectionIsEmptyCheck.isCallToSizeMethod(tree.rightOperand());
    }

    private static boolean isCallToSizeMethod(ExpressionTree tree) {
        if (!tree.is(Tree.Kind.METHOD_INVOCATION)) {
            return false;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
        return methodInvocationTree.arguments().isEmpty() && methodInvocationTree.methodSelect().is(Tree.Kind.MEMBER_SELECT) && "size".equals(((MemberSelectExpressionTree)methodInvocationTree.methodSelect()).identifier().name());
    }

    private static boolean isEmptyComparison(BinaryExpressionTree tree) {
        boolean result = CollectionIsEmptyCheck.isEqualityExpression(tree) ? CollectionIsEmptyCheck.isZero(tree.leftOperand()) || CollectionIsEmptyCheck.isZero(tree.rightOperand()) : (tree.is(Tree.Kind.GREATER_THAN_OR_EQUAL_TO) || tree.is(Tree.Kind.LESS_THAN) ? CollectionIsEmptyCheck.isZero(tree.leftOperand()) || CollectionIsEmptyCheck.isOne(tree.rightOperand()) : (tree.is(Tree.Kind.GREATER_THAN) || tree.is(Tree.Kind.LESS_THAN_OR_EQUAL_TO) ? CollectionIsEmptyCheck.isOne(tree.leftOperand()) || CollectionIsEmptyCheck.isZero(tree.rightOperand()) : false));
        return result;
    }

    private static boolean isEqualityExpression(BinaryExpressionTree tree) {
        return tree.is(Tree.Kind.EQUAL_TO) || tree.is(Tree.Kind.NOT_EQUAL_TO);
    }

    private static boolean isZero(ExpressionTree tree) {
        return tree.is(Tree.Kind.INT_LITERAL) && "0".equals(((LiteralTree)tree).value());
    }

    private static boolean isOne(ExpressionTree tree) {
        return tree.is(Tree.Kind.INT_LITERAL) && "1".equals(((LiteralTree)tree).value());
    }
}

